/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.controller;

import edu.colorado.phet.common.controls.SpectrumSliderWithSquareCursor;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.util.SwingThreadModelListener;
import edu.colorado.phet.common.phetcommon.view.controls.IntensitySlider;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic2;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.photoelectric.PhotoelectricResources;
import edu.colorado.phet.photoelectric.controller.IntensityReadout;
import edu.colorado.phet.photoelectric.controller.SpectrumSliderWithReadout;
import edu.colorado.phet.photoelectric.model.util.PhotoelectricModelUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BeamControl
extends GraphicLayerSet
implements SwingThreadModelListener,
PhotonSource.RateChangeListener {
    private IntesitySliderChangeListener intesitySliderChangeListener;
    private Point orgIntensitySliderLoc;
    private Point orgBeamControlLocation;
    private Dimension orgIntensitySliderSize;
    public static final Mode INTENSITY = new Mode();
    public static final Mode RATE = new Mode();
    private static Map MODE_TO_SLIDER_TITLE = new HashMap();
    private ApparatusPanel apparatusPanel;
    private IntensitySlider intensitySlider;
    private PhetTextGraphic2 sliderTitle;
    private Point intensitySliderRelLoc = new Point(68, 28);
    private Dimension intensitySliderSize = new Dimension(142, 16);
    private Point intensitySliderLoc;
    private Point spectrumSliderLoc;
    private Point spectrumSliderRelLoc = new Point(13, 93);
    private Dimension spectrumSize = new Dimension(145, 19);
    private SpectrumSliderWithReadout wavelengthSlider;
    private Beam beam;
    private boolean selfUpdating;
    private Mode mode;
    private EventChannel changeEventChannel = new EventChannel(BeamChangeListener.class);
    private BeamChangeListener changeListenerProxy = (BeamChangeListener)this.changeEventChannel.getListenerProxy();
    private Dimension orgAppPanelSize;
    private AffineTransform intensitySliderAtx = new AffineTransform();

    public BeamControl(ApparatusPanel apparatusPanel, Point point, Beam beam, double d) {
        this.apparatusPanel = apparatusPanel;
        this.beam = beam;
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic((Component)apparatusPanel, PhotoelectricResources.getImage("photoelectric-beam-control.png"));
        phetImageGraphic.setRegistrationPoint(100, 0);
        this.addGraphic(phetImageGraphic);
        phetImageGraphic.setLocation(0, 0);
        this.intensitySliderLoc = new Point(point.x + this.intensitySliderRelLoc.x, point.y + this.intensitySliderRelLoc.y);
        this.spectrumSliderLoc = new Point(point.x + this.spectrumSliderRelLoc.x, point.y + this.spectrumSliderRelLoc.y);
        this.setLocation(point);
        this.addIntensitySlider(beam, d);
        this.addWavelengthSlider(beam);
        beam.addRateChangeListener(this);
        this.apparatusPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (BeamControl.this.orgAppPanelSize == null) {
                    BeamControl.this.orgBeamControlLocation = BeamControl.this.getLocation();
                    BeamControl.this.orgAppPanelSize = BeamControl.this.apparatusPanel.getSize();
                    BeamControl.this.orgIntensitySliderLoc = BeamControl.this.intensitySlider.getLocation();
                    BeamControl.this.orgIntensitySliderSize = BeamControl.this.intensitySlider.getPreferredSize();
                } else {
                    Dimension dimension = BeamControl.this.apparatusPanel.getSize();
                    double d = dimension.getWidth() / BeamControl.this.orgAppPanelSize.getWidth();
                    BeamControl.this.intensitySliderAtx = AffineTransform.getScaleInstance(d, d);
                    double d2 = BeamControl.this.orgIntensitySliderLoc.getX() * d;
                    double d3 = BeamControl.this.orgIntensitySliderLoc.getY() * d;
                    BeamControl.this.intensitySlider.setLocation((int)d2, (int)d3);
                    BeamControl.this.setBoundsDirty();
                    BeamControl.this.repaint();
                }
            }
        });
        this.setMode(INTENSITY);
    }

    private void addWavelengthSlider(final Beam beam) {
        SpectrumSliderWithSquareCursor spectrumSliderWithSquareCursor = new SpectrumSliderWithSquareCursor(this.apparatusPanel, 100.0, 850.0);
        this.wavelengthSlider = new SpectrumSliderWithReadout(this.apparatusPanel, spectrumSliderWithSquareCursor, beam, 100.0, 850.0, this.spectrumSliderLoc);
        this.wavelengthSlider.setLocation(this.spectrumSliderRelLoc);
        this.wavelengthSlider.setOrientation(0);
        this.wavelengthSlider.setTransmissionWidth(1.0);
        this.wavelengthSlider.setKnobSize(new Dimension(20, 20));
        this.wavelengthSlider.setSpectrumSize(this.spectrumSize);
        this.wavelengthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PhetUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int n = (int)MathUtil.clamp(100.0, (double)BeamControl.this.wavelengthSlider.getValue(), 850.0);
                        beam.setWavelength(n);
                        BeamControl.this.intesitySliderChangeListener.stateChanged(new ChangeEvent(beam));
                    }
                });
            }
        });
        this.wavelengthSlider.setValue((int)beam.getWavelength());
        this.addGraphic(this.wavelengthSlider, 220.0);
    }

    private void addIntensitySlider(Beam beam, double d) {
        this.intensitySlider = new MyIntensitySlider(VisibleColor.wavelengthToColor(beam.getWavelength()), IntensitySlider.HORIZONTAL, this.intensitySliderSize);
        this.intensitySlider.setMaximum((int)d);
        this.intensitySlider.setLocation(this.intensitySliderLoc);
        this.apparatusPanel.add(this.intensitySlider);
        IntensityReadout intensityReadout = new IntensityReadout(this.apparatusPanel, beam);
        intensityReadout.setLocation((int)(this.intensitySliderLoc.getX() + (double)this.intensitySlider.getWidth()) + 4, (int)(this.intensitySliderLoc.getY() + (double)(this.intensitySlider.getHeight() / 2) - (double)(intensityReadout.getHeight() / 2)) - 1);
        this.addChangeListener(intensityReadout);
        this.apparatusPanel.addGraphic(intensityReadout, 1.0E14);
        this.intensitySlider.setValue(0);
        this.intesitySliderChangeListener = new IntesitySliderChangeListener(beam);
        this.intensitySlider.addChangeListener(this.intesitySliderChangeListener);
        beam.setPhotonsPerSecond(this.intensitySlider.getValue());
        beam.addWavelengthChangeListener(new PhotonSource.WavelengthChangeListener(){

            public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
                Color color = VisibleColor.wavelengthToColor(wavelengthChangeEvent.getWavelength());
                BeamControl.this.intensitySlider.setColor(color);
            }
        });
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.intensitySlider.setVisible(bl);
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.intesitySliderChangeListener.stateChanged(new ChangeEvent(this.beam));
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
        this.setSliderTitle(mode);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void addChangeListener(BeamChangeListener beamChangeListener) {
        this.changeEventChannel.addListener(beamChangeListener);
    }

    private void setSliderTitle(Mode mode) {
        if (this.sliderTitle != null) {
            this.removeGraphic(this.sliderTitle);
        }
        Font font = new Font(LasersConfig.DEFAULT_CONTROL_FONT.getName(), LasersConfig.DEFAULT_CONTROL_FONT.getStyle(), LasersConfig.DEFAULT_CONTROL_FONT.getSize() + 4);
        String string = (String)MODE_TO_SLIDER_TITLE.get(mode);
        this.sliderTitle = new PhetTextGraphic2(this.apparatusPanel, font, string, Color.white);
        FontMetrics fontMetrics = this.apparatusPanel.getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        this.sliderTitle.setLocation((int)(this.intensitySliderRelLoc.getX() + (double)(this.intensitySliderSize.width / 2) - (double)(n / 2) + 10.0), (int)(this.intensitySliderRelLoc.getY() - (double)this.sliderTitle.getHeight() - 20.0));
        this.addGraphic(this.sliderTitle);
    }

    public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
        if (!this.selfUpdating) {
            this.intensitySlider.setValue((int)this.beam.getPhotonsPerSecond());
        }
    }

    static {
        MODE_TO_SLIDER_TITLE.put(INTENSITY, PhotoelectricResources.getString("BeamControl.intensity"));
        MODE_TO_SLIDER_TITLE.put(RATE, PhotoelectricResources.getString("BeamControl.photonRate"));
    }

    public static interface BeamChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }

    private class IntesitySliderChangeListener
    implements ChangeListener {
        private final Beam beam;

        public IntesitySliderChangeListener(Beam beam) {
            this.beam = beam;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            PhetUtilities.invokeLater(new Runnable(){

                public void run() {
                    BeamControl.this.selfUpdating = true;
                    double d = BeamControl.this.intensitySlider.getValue();
                    if (BeamControl.this.mode == INTENSITY) {
                        d = PhotoelectricModelUtil.intensityToPhotonRate(d, IntesitySliderChangeListener.this.beam.getWavelength());
                    }
                    IntesitySliderChangeListener.this.beam.setPhotonsPerSecond(d);
                    BeamControl.this.selfUpdating = false;
                }
            });
        }
    }

    public static class Mode {
        private Mode() {
        }
    }

    private class MyIntensitySlider
    extends IntensitySlider {
        public MyIntensitySlider(Color color, int n, Dimension dimension) {
            super(color, n, dimension);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(BeamControl.this.intensitySliderAtx);
            super.paintComponent(graphics);
            graphics2D.setTransform(affineTransform);
        }
    }
}

