/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.controller;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.controller.HighLevelEmissionControlPanel;
import edu.colorado.phet.lasers.controller.LaserControlPanel;
import edu.colorado.phet.lasers.controller.LasersLegend;
import edu.colorado.phet.lasers.controller.MirrorOnOffControlPanel;
import edu.colorado.phet.lasers.controller.WaveViewControlPanel;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.view.LampGraphic;
import edu.colorado.phet.lasers.view.PumpBeamViewPanel;
import edu.colorado.phet.lasers.view.util.ViewUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class UniversalLaserControlPanel
extends LaserControlPanel {
    private BaseLaserModule laserModule;
    private WaveViewControlPanel waveViewControlPanel;
    private BasicOptionsPanel basicBasicOptionsPanel;
    private HighLevelEmissionControlPanel highLevelEmissionControlPanel;
    private PumpBeamViewPanel pumpBeamViewPanel;

    public UniversalLaserControlPanel(final BaseLaserModule baseLaserModule, boolean bl) {
        super(baseLaserModule);
        this.laserModule = baseLaserModule;
        this.addControl(baseLaserModule.getEnergyLevelsMonitorPanel());
        if (bl) {
            this.addControl(new LasersLegend());
        }
        this.waveViewControlPanel = new WaveViewControlPanel(baseLaserModule);
        this.highLevelEmissionControlPanel = new HighLevelEmissionControlPanel(baseLaserModule);
        this.basicBasicOptionsPanel = new BasicOptionsPanel(baseLaserModule.getThreeEnergyLevels());
        this.addControl(this.basicBasicOptionsPanel);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        gridBagConstraints.anchor = 18;
        ViewUtils.setBorder(jPanel, LasersResources.getString("LaserControlPanel.OptionsBorderTitle"));
        gridBagConstraints.anchor = 10;
        JPanel jPanel2 = this.createMirrorControlPanel(baseLaserModule);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.highLevelEmissionControlPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.pumpBeamViewPanel = new PumpBeamViewPanel(baseLaserModule);
        jPanel.add((Component)this.pumpBeamViewPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.waveViewControlPanel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        jPanel3.setBorder(border);
        jPanel3.add(jPanel);
        super.addControl(jPanel);
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton(LasersResources.getString("LaserControlPanel.Reset"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PhetOptionPane.showYesNoDialog(PhetApplication.getInstance().getPhetFrame(), LasersResources.getString("ResetAll.confirmationMessage"));
                if (n == 0) {
                    baseLaserModule.reset();
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jButton);
        super.addControl(jPanel4);
        this.doLayout();
        this.setPreferredSize(new Dimension(340, (int)this.getSize().getHeight()));
        baseLaserModule.getPumpLampGraphic().addChangeListener(new LampGraphic.ChangeListener(){

            public void changed(LampGraphic.ChangeEvent changeEvent) {
                UniversalLaserControlPanel.this.pumpBeamViewPanel.setVisible(changeEvent.getLampGraphic().isVisible());
            }
        });
    }

    private JPanel createMirrorControlPanel(BaseLaserModule baseLaserModule) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add((Component)new MirrorOnOffControlPanel(baseLaserModule), gridBagConstraints);
        return jPanel;
    }

    public void setThreeEnergyLevels(boolean bl) {
        this.laserModule.setThreeEnergyLevels(bl);
        this.waveViewControlPanel.setVisible(bl);
        this.highLevelEmissionControlPanel.setVisible(bl);
    }

    public void setUpperTransitionView(int n) {
        this.pumpBeamViewPanel.setUpperTransitionView(n);
    }

    private class BasicOptionsPanel
    extends JPanel {
        private JRadioButton twoLevelsRB;
        private JRadioButton threeLevelsRB;

        BasicOptionsPanel(boolean bl) {
            this.twoLevelsRB = new JRadioButton(new AbstractAction(LasersResources.getString("LaserControlPanel.TwoLevelsRadioButton")){

                public void actionPerformed(ActionEvent actionEvent) {
                    UniversalLaserControlPanel.this.setThreeEnergyLevels(false);
                }
            });
            this.threeLevelsRB = new JRadioButton(new AbstractAction(LasersResources.getString("LaserControlPanel.ThreeLevelsRadioButton")){

                public void actionPerformed(ActionEvent actionEvent) {
                    UniversalLaserControlPanel.this.setThreeEnergyLevels(true);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.twoLevelsRB);
            buttonGroup.add(this.threeLevelsRB);
            JPanel jPanel = new JPanel();
            jPanel.add(this.twoLevelsRB);
            jPanel.add(this.threeLevelsRB);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
            ViewUtils.setBorder(this, LasersResources.getString("LaserControlPanel.EnergyLevelsBorderTitle"));
            this.add((Component)jPanel, gridBagConstraints);
            this.twoLevelsRB.setSelected(!bl);
            this.threeLevelsRB.setSelected(bl);
            UniversalLaserControlPanel.this.setThreeEnergyLevels(bl);
        }
    }
}

