/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.quantum.model;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollisionExpert;
import edu.colorado.phet.common.collision.CollisionUtil;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class ElectronAtomCollisionExpert
implements CollisionExpert {
    private Object[] bodies = new Object[2];
    private Map classifiedBodies = new HashMap();
    private Class[] classes = new Class[]{Electron.class, DischargeLampAtom.class};
    private Ellipse2D atomArea = new Ellipse2D.Double();
    private Rectangle2D electronPath = new Rectangle2D.Double();

    public ElectronAtomCollisionExpert() {
        this.classifiedBodies.put(Electron.class, null);
        this.classifiedBodies.put(DischargeLampAtom.class, null);
    }

    public boolean detectAndDoCollision(Collidable collidable, Collidable collidable2) {
        this.bodies[0] = collidable;
        this.bodies[1] = collidable2;
        CollisionUtil.classifyBodies(this.bodies, this.classes, this.classifiedBodies);
        DischargeLampAtom dischargeLampAtom = (DischargeLampAtom)this.classifiedBodies.get(DischargeLampAtom.class);
        Electron electron = (Electron)this.classifiedBodies.get(Electron.class);
        if (dischargeLampAtom != null && electron != null) {
            double d;
            double d2 = electron.getPositionPrev().distanceSq(dischargeLampAtom.getPosition());
            double d3 = electron.getPosition().distanceSq(dischargeLampAtom.getPosition());
            if (d3 <= (d = (dischargeLampAtom.getRadius() + electron.getRadius()) * (dischargeLampAtom.getRadius() + electron.getRadius())) && d2 > d) {
                dischargeLampAtom.collideWithElectron(electron);
                return false;
            }
            this.atomArea.setFrame(dischargeLampAtom.getPosition().getX() - dischargeLampAtom.getBaseRadius(), dischargeLampAtom.getPosition().getY() - dischargeLampAtom.getBaseRadius(), dischargeLampAtom.getBaseRadius() * 2.0, dischargeLampAtom.getBaseRadius() * 2.0);
            this.electronPath.setRect(electron.getPositionPrev().getX(), electron.getPositionPrev().getY(), electron.getPosition().getX() - electron.getPositionPrev().getX(), 1.0);
            if (this.atomArea.intersects(this.electronPath)) {
                dischargeLampAtom.collideWithElectron(electron);
                return false;
            }
        }
        return false;
    }
}

