/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import edu.colorado.phet.common.phetcommon.math.DoubleSeries;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClockProfiler {
    private JDialog frame;
    private ConstantDtClock clock;
    private JLabel frameRate;
    private int NUM_SAMPLES = 20;
    private DoubleSeries delaySeries = new DoubleSeries(this.NUM_SAMPLES);
    private long lastTickTime = 0L;
    private LinearValueControl linearValueControl;
    private ClockAdapter tickListener;

    public ClockProfiler(JFrame jFrame, String string, ConstantDtClock constantDtClock) {
        this.clock = constantDtClock;
        this.frame = new JDialog(jFrame, "Profiler: " + string, false);
        this.tickListener = new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                ClockProfiler.this.delaySeries.add(System.currentTimeMillis() - ClockProfiler.this.lastTickTime);
                ClockProfiler.this.lastTickTime = System.currentTimeMillis();
                ClockProfiler.this.updateLabels();
            }
        };
        this.clock.addClockListener(this.tickListener);
        this.frameRate = new JLabel("Waiting for data...");
        this.frameRate.setOpaque(true);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        ((Container)verticalLayoutPanel).add(this.frameRate);
        this.linearValueControl = new LinearValueControl(5.0, 100.0, "Clock Delay", "0.0", "ms");
        this.updateDelayControl();
        this.linearValueControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ClockProfiler.this.clock != null) {
                    ClockProfiler.this.clock.setDelay((int)ClockProfiler.this.linearValueControl.getValue());
                }
            }
        });
        ((Container)verticalLayoutPanel).add(this.linearValueControl);
        this.frame.setContentPane(verticalLayoutPanel);
        this.updateLabels();
        this.frame.pack();
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ClockProfiler.this.frame.dispose();
            }
        });
        this.frame.setSize(this.frame.getWidth() + 100, this.frame.getHeight());
    }

    private void updateDelayControl() {
        if (this.clock != null) {
            this.linearValueControl.setValue(this.clock.getDelay());
        }
    }

    private void updateLabels() {
        if (this.delaySeries.getSampleCount() >= (double)this.NUM_SAMPLES) {
            this.frameRate.setText("Frame Rate=" + this.format(1000.0 / this.delaySeries.average()) + " Hz, delay=" + this.format(this.delaySeries.average()) + " millis");
            this.frameRate.paintImmediately(0, 0, this.frameRate.getWidth(), this.frameRate.getHeight());
        }
    }

    private String format(double d) {
        return new DecimalFormat("0.0").format(d);
    }

    public void show() {
        this.frame.setVisible(true);
        if (this.frame.getContentPane() instanceof JComponent) {
            JComponent jComponent = (JComponent)this.frame.getContentPane();
            jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    public void setModule(String string, ConstantDtClock constantDtClock) {
        this.clock.removeClockListener(this.tickListener);
        this.clock = constantDtClock;
        this.clock.addClockListener(this.tickListener);
        this.updateDelayControl();
        this.delaySeries.clear();
        this.frameRate.setText("Switched modules, Waiting for data...");
        this.frameRate.paintImmediately(0, 0, this.frameRate.getWidth(), this.frameRate.getHeight());
        this.frame.setTitle("Profiler: " + string);
    }
}

