/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

public class EventChannel
implements InvocationHandler {
    private List targets = new ArrayList();
    private Class targetInterface;
    private Object proxy;
    private List listenersToAdd = new ArrayList();
    private List listenersToRemove = new ArrayList();
    private boolean invokingTargets;

    public EventChannel(Class clazz) {
        if (!EventListener.class.isAssignableFrom(clazz)) {
            throw new InvalidParameterException("Attempt to create proxy for a class that is not an EventListener");
        }
        this.targetInterface = clazz;
        this.proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    public synchronized void addListener(EventListener eventListener) {
        if (this.targetInterface.isInstance(eventListener)) {
            if (this.invokingTargets) {
                this.listenersToAdd.add(eventListener);
            } else {
                this.targets.add(eventListener);
            }
        } else {
            throw new InvalidParameterException("Parameter is not EventListener");
        }
    }

    public synchronized void removeListener(EventListener eventListener) {
        if (this.targetInterface.isInstance(eventListener)) {
            if (this.invokingTargets) {
                this.listenersToRemove.add(eventListener);
            } else {
                this.targets.remove(eventListener);
            }
        } else {
            throw new InvalidParameterException("Parameter is not EventListener");
        }
    }

    public void removeAllListeners() {
        this.targets.clear();
    }

    public Object getListenerProxy() {
        return this.proxy;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object var4_4 = null;
        try {
            this.invokingTargets = true;
            for (int i = 0; i < this.targets.size(); ++i) {
                var4_4 = this.targets.get(i);
                this.invokeMethod(method, var4_4, objectArray);
            }
            this.invokingTargets = false;
            if (!this.listenersToAdd.isEmpty()) {
                this.targets.addAll(this.listenersToAdd);
                this.listenersToAdd.clear();
            }
            if (!this.listenersToRemove.isEmpty()) {
                this.targets.removeAll(this.listenersToRemove);
                this.listenersToRemove.clear();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvocationTargetException(invocationTargetException, "target = " + var4_4);
        }
        catch (Throwable throwable) {
            System.out.println("t = " + throwable);
            throw new Throwable(throwable);
        }
        return null;
    }

    protected void invokeMethod(Method method, Object object, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
        method.invoke(object, objectArray);
    }
}

