/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model.clock;

import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.model.clock.TimingStrategy;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;

public class ConstantDtClock
extends SwingClock {
    public static final ConstantDtClock TEST = new ConstantDtClock(1, 1.0);
    private EventListenerList listenerList = new EventListenerList();

    public ConstantDtClock() {
        this(30.0);
    }

    public ConstantDtClock(double d) {
        this((int)(1000.0 / d), 1.0 / d);
    }

    public ConstantDtClock(int n, double d) {
        super(n, d);
    }

    public void setDelay(int n) {
        if (n != this.getDelay()) {
            super.setDelay(n);
            this.fireDelayChanged(new ConstantDtClockEvent(this));
        }
    }

    public void setTimingStrategy(TimingStrategy timingStrategy) {
        if (!(timingStrategy instanceof TimingStrategy.Constant)) {
            throw new IllegalArgumentException("timingStrategy must be of type TimingStrategy.Constant");
        }
        super.setTimingStrategy(timingStrategy);
        this.fireDtChanged(new ConstantDtClockEvent(this));
    }

    private void fireDelayChanged(ConstantDtClockEvent constantDtClockEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ConstantDtClockListener.class) continue;
            ((ConstantDtClockListener)objectArray[i + 1]).delayChanged(constantDtClockEvent);
        }
    }

    private void fireDtChanged(ConstantDtClockEvent constantDtClockEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ConstantDtClockListener.class) continue;
            ((ConstantDtClockListener)objectArray[i + 1]).dtChanged(constantDtClockEvent);
        }
    }

    public static class ConstantDtClockEvent
    extends EventObject {
        public ConstantDtClockEvent(ConstantDtClock constantDtClock) {
            super(constantDtClock);
        }
    }

    public static interface ConstantDtClockListener
    extends EventListener {
        public void delayChanged(ConstantDtClockEvent var1);

        public void dtChanged(ConstantDtClockEvent var1);
    }
}

