/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.view;

import edu.colorado.phet.common.charts.GridLineSet;
import edu.colorado.phet.common.charts.LinePlot;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.charts.ScatterPlot;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.photoelectric.PhotoelectricConfig;
import edu.colorado.phet.photoelectric.model.PhotoelectricModel;
import edu.colorado.phet.photoelectric.view.PhotoelectricGraph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.text.DecimalFormat;

public class EnergyVsFrequencyGraph
extends PhotoelectricGraph {
    private static double PLOT_LAYER = 1.0E9;
    private static double freqMultiplier = 1.0E-15;
    private static Range2D range = new Range2D(0.0, 0.0, PhysicsUtil.wavelengthToFrequency(PhotoelectricModel.MIN_WAVELENGTH) * freqMultiplier, PhysicsUtil.wavelengthToEnergy(PhotoelectricModel.MIN_WAVELENGTH));
    private static double xSpacing = (range.getMaxX() - range.getMinX()) / 4.0;
    private static Dimension chartSize = PhotoelectricConfig.CHART_SIZE;
    private double kneeFrequency;
    private double lastFrequencyRecorded;
    private boolean beamOn;

    public EnergyVsFrequencyGraph(Component component, final PhotoelectricModel photoelectricModel) {
        super(component, range, chartSize, xSpacing, xSpacing, 2.0, 2.0);
        GridLineSet gridLineSet = this.getHorizonalGridlines();
        gridLineSet.setMajorGridlinesColor(new Color(200, 200, 200));
        GridLineSet gridLineSet2 = this.getVerticalGridlines();
        gridLineSet2.setMajorGridlinesColor(new Color(200, 200, 200));
        this.getHorizontalTicks().setMajorNumberFormat(new DecimalFormat("0.00"));
        this.getXAxis().setNumberFormat(new DecimalFormat("0.00"));
        Color color = Color.blue;
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 80);
        LinePlot linePlot = new LinePlot(this.getComponent(), this, this.getLineDataSet(), new BasicStroke(3.0f), color2);
        linePlot.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.addDataSetGraphic(linePlot, PLOT_LAYER);
        ScatterPlot scatterPlot = new ScatterPlot(this.getComponent(), this, this.getDotDataSet(), color, 5);
        this.addDataSetGraphic(scatterPlot, PLOT_LAYER + 1.0);
        photoelectricModel.addChangeListener(new PhotoelectricModel.ChangeListenerAdapter(){

            public void targetMaterialChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                EnergyVsFrequencyGraph.this.kneeFrequency = EnergyVsFrequencyGraph.this.determineKneeFrequency(photoelectricModel) * freqMultiplier;
                EnergyVsFrequencyGraph.this.clearLinePlot();
                EnergyVsFrequencyGraph.this.updateGraph(photoelectricModel);
            }

            public void voltageChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                EnergyVsFrequencyGraph.this.kneeFrequency = EnergyVsFrequencyGraph.this.determineKneeFrequency(photoelectricModel) * freqMultiplier;
                EnergyVsFrequencyGraph.this.updateGraph(photoelectricModel);
            }

            public void wavelengthChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                EnergyVsFrequencyGraph.this.updateGraph(photoelectricModel);
            }

            public void beamIntensityChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                if (changeEvent.getPhotoelectricModel().getBeam().getPhotonsPerSecond() == 0.0) {
                    EnergyVsFrequencyGraph.this.beamOn = false;
                    EnergyVsFrequencyGraph.this.getDotDataSet().clear();
                    EnergyVsFrequencyGraph.this.updateGraph(photoelectricModel);
                } else {
                    EnergyVsFrequencyGraph.this.beamOn = true;
                    EnergyVsFrequencyGraph.this.updateGraph(photoelectricModel);
                }
            }
        });
    }

    private double determineKneeFrequency(PhotoelectricModel photoelectricModel) {
        return PhysicsUtil.wavelengthToFrequency(PhysicsUtil.energyToWavelength(photoelectricModel.getWorkFunction()));
    }

    private void updateGraph(PhotoelectricModel photoelectricModel) {
        if (this.beamOn) {
            double d = PhysicsUtil.wavelengthToFrequency(photoelectricModel.getWavelength());
            double d2 = photoelectricModel.getTarget().getMaterial().getWorkFunction();
            double d3 = Math.max(0.0, PhysicsUtil.wavelengthToEnergy(photoelectricModel.getWavelength()) - d2);
            this.addDataPoint(d, d3);
        }
    }

    private void addDataPoint(double d, double d2) {
        this.setDotDataPoint(d *= freqMultiplier, d2);
        if (this.lastFrequencyRecorded < this.kneeFrequency && d > this.kneeFrequency) {
            this.getLineDataSet().addPoint(this.kneeFrequency, 0.0);
        } else if (this.lastFrequencyRecorded > this.kneeFrequency && d < this.kneeFrequency) {
            this.getLineDataSet().addPoint(this.kneeFrequency, 0.0);
        }
        this.getLineDataSet().addPoint(d, d2);
        this.lastFrequencyRecorded = d;
    }
}

