/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.ModelEventChannel;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.PhotonEmissionListener;
import edu.colorado.phet.common.quantum.model.PhotonEmittedEvent;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;
import edu.colorado.phet.dischargelamps.quantum.model.Electrode;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSink;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSource;
import edu.colorado.phet.dischargelamps.quantum.model.Plate;
import edu.colorado.phet.photoelectric.model.Ammeter;
import edu.colorado.phet.photoelectric.model.MetalEnergyAbsorptionStrategy;
import edu.colorado.phet.photoelectric.model.PhotoelectricTarget;
import edu.colorado.phet.photoelectric.model.util.BeamIntensityMeter;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public class PhotoelectricModel
extends DischargeLampModel {
    public static double CURRENT_JIMMY_FACTOR = 0.015;
    public static double MIN_VOLTAGE = -8.0;
    public static double MAX_VOLTAGE = 8.0;
    public static double MIN_WAVELENGTH = 100.0;
    public static double MAX_WAVELENGTH = 800.0;
    public static double MAX_PHOTONS_PER_SECOND = 500.0;
    public static double MAX_CURRENT = MAX_PHOTONS_PER_SECOND * CURRENT_JIMMY_FACTOR / 8.0;
    private List photons = new ArrayList();
    private List electrons = new ArrayList();
    private PhotoelectricTarget target;
    private double defaultTargetPotential = 0.0;
    private ArrayList electronSources = new ArrayList();
    private ArrayList electronSinks = new ArrayList();
    private Plate rightHandPlate;
    private Beam beam;
    private double defaultBeamWavelength = 400.0;
    private double beamWidth = 80.0;
    private double beamHeight = 1000.0;
    private double beamSourceToTargetDist = 260.0;
    private double beamAngle = Math.toRadians(130.0);
    private double beamFanout = Math.toRadians(5.0);
    private Ammeter ammeter;
    private BeamIntensityMeter beamIntensityMeter;
    private double current;
    private double voltage;
    private double wavelength;
    private EventChannel changeEventChannel = new ModelEventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public PhotoelectricModel(IClock iClock) {
        this.getBattery().setMaxVoltage(MAX_VOLTAGE);
        this.getBattery().setMinVoltage(MIN_VOLTAGE);
        double d = this.beamAngle;
        Point2D.Double double_ = new Point2D.Double(DischargeLampsConfig.CATHODE_LOCATION.getX() - Math.cos(d) * this.beamSourceToTargetDist, DischargeLampsConfig.CATHODE_LOCATION.getY() - Math.sin(d) * this.beamSourceToTargetDist);
        this.beam = new Beam(this.defaultBeamWavelength, double_, this.beamHeight, this.beamWidth, new MutableVector2D(Math.cos(this.beamAngle), Math.sin(this.beamAngle)), MAX_PHOTONS_PER_SECOND, this.beamFanout, Photon.DEFAULT_SPEED);
        this.addModelElement(this.beam);
        this.beam.setPhotonsPerSecond(0.0);
        this.beam.setEnabled(true);
        this.beam.addPhotonEmittedListener(new PhotonTracker());
        this.beam.addRateChangeListener(new PhotonSource.RateChangeListener(){

            public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
                PhotoelectricModel.this.changeListenerProxy.beamIntensityChanged(new ChangeEvent(PhotoelectricModel.this));
            }
        });
        this.rightHandPlate = new Plate(this, this, DischargeLampsConfig.ANODE_LINE.getP1(), DischargeLampsConfig.ANODE_LINE.getP2());
        this.addModelElement(this.rightHandPlate);
        this.target = new PhotoelectricTarget(this, DischargeLampsConfig.CATHODE_LINE.getP1(), DischargeLampsConfig.CATHODE_LINE.getP2());
        this.addModelElement(this.target);
        this.target.setPotential(this.defaultTargetPotential);
        this.target.addListener(new ElectronTracker());
        this.target.addMaterialChangeListener(new PhotoelectricTarget.MaterialChangeListener(){

            public void materialChanged(PhotoelectricTarget.MaterialChangeEvent materialChangeEvent) {
                PhotoelectricModel.this.changeListenerProxy.targetMaterialChanged(new ChangeEvent(this));
            }
        });
        this.setRightHandPlate(this.rightHandPlate);
        this.setLeftHandPlate(this.target);
        this.rightHandPlate.addStateChangeListener(new ElectrodeStateChangeListener());
        this.target.addStateChangeListener(new ElectrodeStateChangeListener());
        this.ammeter = new Ammeter(iClock);
        this.getRightHandPlate().addElectronAbsorptionListener(new ElectronSink.ElectronAbsorptionListener(){

            public void electronAbsorbed(ElectronSink.ElectronAbsorptionEvent electronAbsorptionEvent) {
                PhotoelectricModel.this.ammeter.recordElectron();
            }
        });
        this.beamIntensityMeter = new BeamIntensityMeter(iClock);
        this.getBeam().addPhotonEmittedListener(new PhotonEmissionListener(){

            public void photonEmitted(PhotonEmittedEvent photonEmittedEvent) {
                PhotoelectricModel.this.beamIntensityMeter.recordPhoton();
            }
        });
    }

    public void stepInTime(double d) {
        Particle particle;
        int n;
        super.stepInTime(d);
        for (n = 0; n < this.photons.size(); ++n) {
            particle = (Photon)this.photons.get(n);
            if (!this.target.isHitByPhoton((Photon)particle)) continue;
            this.target.handlePhotonCollision((Photon)particle);
            ((Photon)particle).removeFromSystem();
        }
        if (this.getCurrent() != this.current) {
            this.current = this.getCurrent();
            this.changeListenerProxy.currentChanged(new ChangeEvent(this));
        }
        if (this.getVoltage() != this.voltage) {
            this.voltage = this.getVoltage();
            this.changeListenerProxy.voltageChanged(new ChangeEvent(this));
        }
        if (this.beam.getWavelength() != this.wavelength) {
            this.wavelength = this.beam.getWavelength();
            this.changeListenerProxy.wavelengthChanged(new ChangeEvent(this));
        }
        for (n = 0; n < this.electrons.size(); ++n) {
            particle = (Electron)this.electrons.get(n);
            if (this.getTube().getBounds().contains(particle.getPosition())) continue;
            ((Electron)particle).leaveSystem();
        }
    }

    public PhotoelectricTarget getTarget() {
        return this.target;
    }

    public Beam getBeam() {
        return this.beam;
    }

    public Plate getRightHandPlate() {
        return this.rightHandPlate;
    }

    public Ammeter getAmmeter() {
        return this.ammeter;
    }

    public BeamIntensityMeter getBeamIntensityMeter() {
        return this.beamIntensityMeter;
    }

    public double getAnodePotential() {
        return this.rightHandPlate.getPotential() - this.target.getPotential();
    }

    public double getVoltage() {
        return -this.getAnodePotential();
    }

    public double getCurrent() {
        return this.getCurrentForVoltage(this.getVoltage());
    }

    public double getCurrentForVoltage(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.target.getMaterial().getEnergyAbsorptionStrategy() instanceof MetalEnergyAbsorptionStrategy) {
            double d4 = PhysicsUtil.wavelengthToEnergy(this.beam.getWavelength()) - this.target.getMaterial().getWorkFunction();
            double d5 = Math.min(d4 / 4.0, 1.0);
            d2 = d5 * this.beam.getPhotonsPerSecond();
            double d6 = d < 0.0 ? -d : 0.0;
            double d7 = Math.max(0.0, Math.min((d4 - d6) / 4.0, 1.0));
            d3 = d2 * d7;
        } else {
            d3 = d2 = this.beam.getPhotonsPerSecond();
            double d8 = d < 0.0 ? d : 0.0;
            double d9 = d3 = this.getStoppingVoltage() < d8 ? d2 : 0.0;
        }
        if (d3 < 1.0) {
            d3 = 0.0;
        }
        return d3 * CURRENT_JIMMY_FACTOR;
    }

    public double getStoppingVoltage() {
        double d = PhysicsUtil.wavelengthToEnergy(this.beam.getWavelength());
        double d2 = this.getWorkFunction() - d;
        return d2;
    }

    public double getWorkFunction() {
        return this.target.getMaterial().getWorkFunction();
    }

    public double getWavelength() {
        return this.getBeam().getWavelength();
    }

    protected void setElectronAcceleration(double d) {
        super.setElectronAcceleration(d * 0.2865, this.target.getPosition().distance(this.rightHandPlate.getPosition()));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public PhotoelectricModel getPhotoelectricModel() {
            return (PhotoelectricModel)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void currentChanged(ChangeEvent var1);

        public void voltageChanged(ChangeEvent var1);

        public void wavelengthChanged(ChangeEvent var1);

        public void targetMaterialChanged(ChangeEvent var1);

        public void beamIntensityChanged(ChangeEvent var1);
    }

    public static class ChangeListenerAdapter
    implements ChangeListener {
        public void currentChanged(ChangeEvent changeEvent) {
        }

        public void voltageChanged(ChangeEvent changeEvent) {
        }

        public void wavelengthChanged(ChangeEvent changeEvent) {
        }

        public void targetMaterialChanged(ChangeEvent changeEvent) {
        }

        public void beamIntensityChanged(ChangeEvent changeEvent) {
        }
    }

    private class ElectrodeStateChangeListener
    implements Electrode.StateChangeListener {
        private ElectrodeStateChangeListener() {
        }

        public void potentialChanged(Electrode.StateChangeEvent stateChangeEvent) {
            double d = PhotoelectricModel.this.target.getPotential() - PhotoelectricModel.this.rightHandPlate.getPotential();
            PhotoelectricModel.this.setElectronAcceleration(d);
            for (int i = 0; i < PhotoelectricModel.this.electrons.size(); ++i) {
                Electron electron = (Electron)PhotoelectricModel.this.electrons.get(i);
                electron.setAcceleration(PhotoelectricModel.this.getElectronAcceleration());
            }
            PhotoelectricModel.this.setCurrent(PhotoelectricModel.this.current);
        }
    }

    private class ElectronTracker
    implements Electron.ChangeListener,
    ElectronSource.ElectronProductionListener {
        private ElectronTracker() {
        }

        public void electronProduced(ElectronSource.ElectronProductionEvent electronProductionEvent) {
            Electron electron = electronProductionEvent.getElectron();
            PhotoelectricModel.this.addModelElement(electron);
            PhotoelectricModel.this.electrons.add(electron);
            electron.addChangeListener(this);
        }

        public void leftSystem(Electron.ChangeEvent changeEvent) {
            PhotoelectricModel.this.electrons.remove(changeEvent.getElectron());
        }

        public void energyChanged(Electron.ChangeEvent changeEvent) {
        }
    }

    private class PhotonTracker
    implements Photon.LeftSystemEventListener,
    PhotonEmissionListener {
        private PhotonTracker() {
        }

        public void photonEmitted(PhotonEmittedEvent photonEmittedEvent) {
            Photon photon = photonEmittedEvent.getPhoton();
            PhotoelectricModel.this.addModelElement(photon);
            PhotoelectricModel.this.photons.add(photon);
            photon.addLeftSystemListener(this);
        }

        public void leftSystemEventOccurred(Photon.LeftSystemEvent leftSystemEvent) {
            PhotoelectricModel.this.photons.remove(leftSystemEvent.getPhoton());
        }
    }
}

