/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.lasers.LasersResources;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.event.ChangeListener;

public class AtomGraphic
extends CompositePhetGraphic
implements SimpleObserver,
Atom.ChangeListener {
    private static EnergyRepColorStrategy energyRepColorStrategy = new GrayScaleStrategy();
    private static ArrayList changeListenerList = new ArrayList();
    private Atom atom;
    private Color energyRepColor;
    private PhetShapeGraphic energyGraphic;
    private Ellipse2D energyRep;
    private PhetImageGraphic imageGraphic;
    private double energyRepRad;
    private double groundStateRingThickness;
    private double baseImageRad;

    protected static EnergyRepColorStrategy getEnergyRepColorStrategy() {
        return energyRepColorStrategy;
    }

    public static void setEnergyRepColorStrategy(EnergyRepColorStrategy energyRepColorStrategy) {
        AtomGraphic.energyRepColorStrategy = energyRepColorStrategy;
        for (int i = 0; i < changeListenerList.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)changeListenerList.get(i);
        }
    }

    public AtomGraphic(Component component, Atom atom) {
        super(component);
        this.atom = atom;
        this.setIgnoreMouse(true);
        atom.addChangeListener(this);
        BufferedImage bufferedImage = LasersResources.getImage("particle-gray-med.gif");
        double d = 2.0 * atom.getRadius() / (double)bufferedImage.getHeight();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        this.baseImageRad = bufferedImage2.getWidth() / 2;
        this.imageGraphic = new PhetImageGraphic(component, bufferedImage2);
        this.imageGraphic.setRegistrationPoint(this.imageGraphic.getHeight() / 2, this.imageGraphic.getHeight() / 2);
        this.addGraphic(this.imageGraphic, 2.0);
        this.energyGraphic = new PhetShapeGraphic(component, this.energyRep, this.energyRepColor, new BasicStroke(1.0f), Color.black);
        this.addGraphic(this.energyGraphic, 1.0);
        this.update();
    }

    public void update() {
        this.determineEnergyRadiusAndColor();
        this.setLocation((int)this.atom.getPosition().getX(), (int)this.atom.getPosition().getY());
        this.setBoundsDirty();
        this.repaint();
    }

    protected void determineEnergyRadiusAndColor() {
        AtomicState atomicState = this.atom.getCurrState();
        this.groundStateRingThickness = 2.0;
        double d = 0.3;
        double d2 = 0.15;
        double d3 = atomicState.getEnergyLevel() - this.atom.getGroundState().getEnergyLevel();
        this.energyRepRad = d3 * d + this.groundStateRingThickness + this.baseImageRad;
        double d4 = this.atom.getHighestEnergyState().getEnergyLevel() - this.atom.getGroundState().getEnergyLevel();
        double d5 = atomicState.getEnergyLevel() - this.atom.getGroundState().getEnergyLevel();
        double d6 = 6.0;
        this.energyRepRad = d6 * d5 / d4 + this.groundStateRingThickness + this.baseImageRad;
        this.energyRep = new Ellipse2D.Double(-this.energyRepRad, -this.energyRepRad, this.energyRepRad * 2.0, this.energyRepRad * 2.0);
        this.energyGraphic.setShape(this.energyRep);
        this.energyGraphic.setColor(energyRepColorStrategy.getColor(this.atom));
        this.energyGraphic.setColor(Color.green);
        this.atom.setRadius(this.energyRep.getWidth() / 2.0);
    }

    public void paint(Graphics2D graphics2D) {
        this.saveGraphicsState(graphics2D);
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        super.paint(graphics2D);
        this.restoreGraphicsState();
    }

    public void setIsMouseable(boolean bl, final Rectangle2D rectangle2D) {
        this.setIgnoreMouse(!bl);
        if (bl) {
            this.addTranslationListener(new TranslationListener(){

                public void translationOccurred(TranslationEvent translationEvent) {
                    double d = translationEvent.getDx();
                    double d2 = translationEvent.getDy();
                    double d3 = AtomGraphic.this.getLocation().getX();
                    double d4 = AtomGraphic.this.getLocation().getY();
                    double d5 = Math.max(Math.min(rectangle2D.getMaxX(), d3 + d), rectangle2D.getMinX());
                    double d6 = Math.max(Math.min(rectangle2D.getMaxY(), d4 + d2), rectangle2D.getMinY());
                    AtomGraphic.this.atom.setPosition(d5, d6);
                }
            });
        }
    }

    protected PhetShapeGraphic getEnergyGraphic() {
        return this.energyGraphic;
    }

    protected Atom getAtom() {
        return this.atom;
    }

    public void stateChanged(Atom.ChangeEvent changeEvent) {
        this.update();
    }

    public void positionChanged(Atom.ChangeEvent changeEvent) {
        this.update();
    }

    public static interface EnergyRepColorStrategy {
        public Color getColor(Atom var1);
    }

    public static class GrayScaleStrategy
    implements EnergyRepColorStrategy {
        private Color[] grayScale = new Color[240];

        public GrayScaleStrategy() {
            for (int i = 0; i < this.grayScale.length; ++i) {
                this.grayScale[i] = new Color(i, i, i);
            }
        }

        public Color getColor(Atom atom) {
            int n = (int)((double)this.grayScale.length * ((atom.getCurrState().getEnergyLevel() - atom.getGroundState().getEnergyLevel()) / (atom.getHighestEnergyState().getEnergyLevel() - atom.getGroundState().getEnergyLevel())));
            n = Math.min(Math.max(0, n), this.grayScale.length - 1);
            return this.grayScale[n];
        }
    }

    public static class VisibleColorStrategy
    implements EnergyRepColorStrategy {
        public Color getColor(Atom atom) {
            double d = atom.getCurrState().getEnergyLevel() - atom.getGroundState().getEnergyLevel();
            double d2 = PhysicsUtil.energyToWavelength(d);
            Color color = VisibleColor.wavelengthToColor(d2);
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
            return color2;
        }
    }
}

