/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.view.AtomGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;

public class AnnotatedAtomGraphic
extends AtomGraphic
implements Atom.ChangeListener {
    private static BufferedImage[] characters;
    private PhetImageGraphic[] characterGraphics = new PhetImageGraphic[characters.length];
    private long colorTime = 100L;
    private Atom atom;
    PhetGraphic numberGraphic;

    public AnnotatedAtomGraphic(Component component, Atom atom) {
        super(component, atom);
        this.atom = atom;
        for (int i = 0; i < characters.length; ++i) {
            this.characterGraphics[i] = new PhetImageGraphic(component, characters[i]);
            this.characterGraphics[i].setRegistrationPoint(characters[i].getWidth() / 2, characters[i].getHeight() / 2);
        }
        this.getEnergyGraphic().setStroke(new BasicStroke(0.5f));
        this.getEnergyGraphic().setBorderColor(Color.black);
        this.numberGraphic = this.characterGraphics[0];
        this.addGraphic(this.numberGraphic, 1000.0);
        this.determineEnergyRadiusAndColor();
        this.getEnergyGraphic().setColor(AnnotatedAtomGraphic.getEnergyRepColorStrategy().getColor(atom));
        this.setNumberGraphicText();
        this.update();
    }

    protected void setNumberGraphicText() {
        int n = this.atom.getCurrStateNumber();
        this.removeGraphic(this.numberGraphic);
        this.numberGraphic = this.characterGraphics[n];
        this.addGraphic(this.numberGraphic, 1000.0);
    }

    public void update() {
        this.setLocation((int)this.getAtom().getPosition().getX(), (int)this.getAtom().getPosition().getY());
        this.setBoundsDirty();
        this.repaint();
    }

    public void stateChanged(Atom.ChangeEvent changeEvent) {
        this.determineEnergyRadiusAndColor();
        this.getEnergyGraphic().setColor(AnnotatedAtomGraphic.getEnergyRepColorStrategy().getColor(this.atom));
        this.setNumberGraphicText();
        this.update();
    }

    static {
        try {
            characters = new BufferedImage[]{LasersResources.getImage("1.png"), LasersResources.getImage("2.png"), LasersResources.getImage("3.png"), LasersResources.getImage("4.png"), LasersResources.getImage("5.png"), LasersResources.getImage("6.png"), LasersResources.getImage("7.png"), LasersResources.getImage("8.png"), LasersResources.getImage("9.png"), LasersResources.getImage("10.png")};
        }
        catch (Exception exception) {
            System.out.println("e = " + exception);
        }
    }
}

