/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.controller.module;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.ElementProperties;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.lasers.LasersApplication;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.controller.BeamControl;
import edu.colorado.phet.lasers.controller.UniversalLaserControlPanel;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.model.atom.LaserAtom;
import edu.colorado.phet.lasers.model.atom.LaserElementProperties;
import edu.colorado.phet.lasers.model.atom.ThreeLevelElementProperties;
import edu.colorado.phet.lasers.model.atom.TwoLevelElementProperties;
import edu.colorado.phet.lasers.view.LampGraphic;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class MultipleAtomModule
extends BaseLaserModule {
    private double s_maxSpeed = 0.1;
    private ArrayList atoms;
    private UniversalLaserControlPanel laserControlPanel;
    private BeamControl pumpBeamControl;

    public MultipleAtomModule(PhetFrame phetFrame, IClock iClock) {
        super(phetFrame, LasersResources.getString("ModuleTitle.MultipleAtomModule"), iClock, Photon.DEFAULT_SPEED * LasersApplication.MULTI_ATOM_MODULE_SPEED);
        Object object;
        Object object2;
        AffineTransform affineTransform;
        Tube tube = this.getCavity();
        Rectangle2D rectangle2D = tube.getBounds();
        Point2D.Double double_ = new Point2D.Double(s_origin.getX(), s_origin.getY());
        Beam beam = ((LaserModel)this.getModel()).getSeedBeam();
        beam.setPosition(double_);
        beam.setBeamWidth(120.0);
        beam.setDirection(new MutableVector2D(1.0, 0.0));
        beam.setPhotonsPerSecond(1.0);
        Beam beam2 = ((LaserModel)this.getModel()).getPumpingBeam();
        Point2D.Double double_2 = new Point2D.Double(this.getCavity().getBounds().getX() + this.getCavity().getBounds().getWidth() / 2.0, this.getCavity().getBounds().getY() - 100.0);
        beam2.setPosition(double_2);
        beam2.setBeamWidth(rectangle2D.getWidth());
        beam2.setFanout(LasersConfig.PUMPING_BEAM_FANOUT);
        beam2.setMaxPhotonsPerSecond(400);
        beam2.setPhotonsPerSecond(0.0);
        beam.setEnabled(false);
        beam2.setEnabled(true);
        BufferedImage bufferedImage = LasersResources.getImage("flashlight.png");
        int n = 8;
        double d = 10.0;
        double d2 = (tube.getMinY() - 100.0 - d) / (double)bufferedImage.getWidth();
        double d3 = beam2.getBeamWidth() / (double)n / (double)bufferedImage.getHeight();
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d2, d3), 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        for (int i = 0; i < n; ++i) {
            affineTransform = new AffineTransform();
            affineTransform.translate(tube.getMinX() + (double)(bufferedImage2.getHeight() * (i + 1)), d);
            affineTransform.rotate(1.5707963267948966);
            object2 = new AffineTransformOp(new AffineTransform(), 2).filter(bufferedImage2, null);
            object = new LampGraphic(beam2, this.getApparatusPanel(), (BufferedImage)object2, affineTransform);
            this.setPumpLampGraphic((LampGraphic)object);
            this.addGraphic((PhetGraphic)object, 14.0);
        }
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic((Component)this.getApparatusPanel(), LasersResources.getImage("wire.png"));
        affineTransform = AffineTransform.getScaleInstance(4.0, 1.0);
        object2 = new AffineTransformOp(affineTransform, 2);
        phetImageGraphic.setImage(((AffineTransformOp)object2).filter(phetImageGraphic.getImage(), null));
        phetImageGraphic.setLocation(180, 50);
        this.getApparatusPanel().addGraphic(phetImageGraphic);
        object = new Point((int)tube.getBounds().getMaxX() + 140, 10);
        this.pumpBeamControl = new BeamControl(this.getApparatusPanel(), this, (Point)object, beam2, 380.0, 780.0, LasersResources.getImage("beam-control.png"));
        this.getApparatusPanel().addGraphic(this.pumpBeamControl);
        this.addAtoms(rectangle2D);
        this.setThreeEnergyLevels(true);
        this.setEnergyLevelsAveragingPeriod(0.0);
        this.laserControlPanel = new UniversalLaserControlPanel(this, false);
        this.setControlPanel(this.laserControlPanel);
        this.laserControlPanel.setUpperTransitionView(2);
    }

    public void reset() {
        super.reset();
        this.deactivate();
        this.setThreeEnergyLevels(true);
        this.setEnergyLevelsAveragingPeriod(0.0);
        this.laserControlPanel = new UniversalLaserControlPanel(this, false);
        this.setControlPanel(this.laserControlPanel);
        this.laserControlPanel.setUpperTransitionView(2);
        this.laserControlPanel.setThreeEnergyLevels(true);
        this.setMirrorsEnabled(false);
        this.setDisplayHighLevelEmissions(false);
        this.activate();
        ThreeLevelElementProperties threeLevelElementProperties = new ThreeLevelElementProperties();
        Atom atom = (Atom)this.atoms.get(0);
        AtomicState[] atomicStateArray = atom.getStates();
        for (int i = 0; i < atomicStateArray.length; ++i) {
            AtomicState atomicState = atomicStateArray[i];
            atomicState.setEnergyLevel(threeLevelElementProperties.getStates()[i].getEnergyLevel());
            atomicState.setEnergyLevel(threeLevelElementProperties.getStates()[i].getEnergyLevel());
        }
    }

    private void addAtoms(Rectangle2D rectangle2D) {
        LaserAtom laserAtom = null;
        this.atoms = new ArrayList();
        int n = 30;
        for (int i = 0; i < n; ++i) {
            LaserElementProperties laserElementProperties = this.getThreeEnergyLevels() ? new ThreeLevelElementProperties() : new TwoLevelElementProperties();
            laserAtom = new LaserAtom(this.getLaserModel(), (ElementProperties)laserElementProperties);
            boolean bl = false;
            int n2 = 0;
            do {
                bl = true;
                laserAtom.setPosition(rectangle2D.getX() + Math.random() * (rectangle2D.getWidth() - laserAtom.getRadius() * 4.0) + laserAtom.getRadius() * 2.0, rectangle2D.getY() + Math.random() * (rectangle2D.getHeight() - laserAtom.getRadius() * 4.0) + laserAtom.getRadius() * 2.0);
                laserAtom.setVelocity((double)((float)(Math.random() - 0.5)) * this.s_maxSpeed, (double)((float)(Math.random() - 0.5)) * this.s_maxSpeed);
                for (int j = 0; j < this.atoms.size(); ++j) {
                    Atom atom = (Atom)this.atoms.get(j);
                    double d = laserAtom.getPosition().distance(atom.getPosition());
                }
                if (n2 <= 1000) continue;
                System.out.println("Unable to place all atoms");
                break;
            } while (!bl);
            this.atoms.add(laserAtom);
            this.addAtom(laserAtom);
        }
    }

    public void setThreeEnergyLevels(boolean bl) {
        super.setThreeEnergyLevels(bl);
        this.getLaserModel().getPumpingBeam().setEnabled(true);
    }
}

