/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.controller;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.util.FrameSequence;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.model.LaserModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class Kaboom
implements ModelElement {
    private BaseLaserModule module;
    private LaserModel model;
    private boolean kaboomed;
    private List kaboomGraphics = new ArrayList();
    private JLabel labelMessage;
    private PhetShapeGraphic backgroundGraphic;
    private double blackBacgroundLayer = Double.MAX_VALUE;
    private double tileLayer = Double.MAX_VALUE;
    private SwingClock clock;

    public Kaboom(BaseLaserModule baseLaserModule) {
        if (baseLaserModule.getApparatusPanel() == null) {
            throw new RuntimeException("Module doesn't have an apparatus panel");
        }
        this.module = baseLaserModule;
        this.model = baseLaserModule.getLaserModel();
        this.clock = new SwingClock(25, 1.0);
        baseLaserModule.getLaserModel().getPumpingBeam().addRateChangeListener(new PhotonSource.RateChangeListener(){

            public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
                if (Kaboom.this.kaboomed) {
                    Kaboom.this.kaboomed = false;
                    Kaboom.this.model.setModelPaused(false);
                    Kaboom.this.reset();
                }
            }
        });
        baseLaserModule.getLaserModel().getSeedBeam().addRateChangeListener(new PhotonSource.RateChangeListener(){

            public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
                if (Kaboom.this.kaboomed) {
                    Kaboom.this.kaboomed = false;
                    Kaboom.this.model.setModelPaused(false);
                    Kaboom.this.reset();
                }
            }
        });
    }

    public void stepInTime(double d) {
        if (this.model.getNumLasingPhotons() > LasersConfig.KABOOM_THRESHOLD && !this.kaboomed) {
            this.model.reset();
            this.kaboom();
            this.model.setModelPaused(true);
            this.kaboomed = true;
        }
    }

    private void kaboom() {
        ApparatusPanel2 apparatusPanel2 = (ApparatusPanel2)this.module.getApparatusPanel();
        Tube tube = this.module.getCavity();
        Rectangle2D rectangle2D = tube.getBounds();
        rectangle2D = RectangleUtils.expand(rectangle2D, 30.0, 20.0);
        rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), (double)apparatusPanel2.getWidth() - rectangle2D.getMinX(), rectangle2D.getHeight());
        this.backgroundGraphic = new PhetShapeGraphic(apparatusPanel2, rectangle2D, Color.white);
        apparatusPanel2.addGraphic(this.backgroundGraphic, this.blackBacgroundLayer);
        this.clock.start();
        Flames flames = new Flames(apparatusPanel2, this.clock);
        flames.setLocation((int)tube.getBounds().getMinX(), (int)tube.getBounds().getMaxY() - flames.getHeight());
        apparatusPanel2.addGraphic(flames, this.tileLayer - 0.5);
        this.labelMessage = new JLabel(LasersResources.getString("Kaboom.message"));
        this.labelMessage.setFont(new PhetFont(1, 24));
        this.labelMessage.setForeground(Color.red);
        this.labelMessage.setLocation(-20, 10);
        apparatusPanel2.add(this.labelMessage);
        this.labelMessage.reshape(apparatusPanel2.getWidth() / 2 - 200, apparatusPanel2.getHeight() / 2 - 70, this.labelMessage.getPreferredSize().width, this.labelMessage.getPreferredSize().height);
        apparatusPanel2.revalidate();
    }

    public void reset() {
        ApparatusPanel apparatusPanel = this.module.getApparatusPanel();
        List list = this.getKaboomGraphics();
        for (int i = 0; i < list.size(); ++i) {
            PhetGraphic phetGraphic = (PhetGraphic)list.get(i);
            apparatusPanel.removeGraphic(phetGraphic);
        }
        if (this.backgroundGraphic != null) {
            apparatusPanel.removeGraphic(this.backgroundGraphic);
        }
        if (this.labelMessage != null) {
            apparatusPanel.remove(this.labelMessage);
        }
        apparatusPanel.revalidate();
        apparatusPanel.repaint();
        if (this.clock != null && this.clock.isRunning()) {
            this.clock.pause();
        }
    }

    public List getKaboomGraphics() {
        return this.kaboomGraphics;
    }

    private class Flames
    extends PhetImageGraphic {
        FrameSequence frames;

        protected Flames(final Component component, final IClock iClock) {
            super(component);
            try {
                this.frames = new FrameSequence("lasers/images/flames", 15);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setImage(this.frames.getFrame(0));
            iClock.addClockListener(new ClockAdapter(){

                public void clockTicked(ClockEvent clockEvent) {
                    if (Flames.this.frames.getCurrFrameNum() == Flames.this.frames.getNumFrames() - 1) {
                        iClock.removeClockListener(this);
                        ((ApparatusPanel)component).removeGraphic(Flames.this);
                    } else {
                        Flames.this.nextFrame();
                    }
                }
            });
        }

        public void nextFrame() {
            this.setImage(this.frames.getNextFrame());
        }
    }
}

