/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.dischargelamps.model.HeatingElement;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class HeatingElementGraphic
extends PhetImageGraphic
implements HeatingElement.ChangeListener {
    private BufferedImage baseImage = BufferedImageUtils.flipY(this.baseImage);

    public HeatingElementGraphic(Component component, boolean bl) {
        super(component);
        if (bl) {
            this.baseImage = BufferedImageUtils.flipX(this.baseImage);
        }
        this.setImage(this.baseImage);
    }

    private void setFilteredImage(HeatingElement heatingElement) {
        double d = heatingElement.getTemperature();
        BufferedImage bufferedImage = this.baseImage;
        ColorModel colorModel = bufferedImage.getColorModel();
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n = bufferedImage.getRGB(i, j);
                int n2 = colorModel.getAlpha(n);
                int n3 = Math.min((int)d, 255);
                int n4 = 0;
                int n5 = 0;
                int n6 = n2 * 0x1000000 + n3 * 65536 + n4 * 256 + n5 * 1;
                bufferedImage.setRGB(i, j, n6);
            }
        }
        float f = 0.03125f * (float)(d / 255.0);
        float f2 = 0.11111111f * (float)(d / 255.0);
        float f3 = 1.0f - f2 - f;
        float[] fArray = new float[]{f, f, f, f, f, f, f2, f2, f2, f, f, f2, f3, f2, f, f, f2, f2, f2, f, f, f, f, f, f};
        Kernel kernel = new Kernel(5, 5, fArray);
        ConvolveOp convolveOp = new ConvolveOp(kernel, 1, new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        bufferedImage = convolveOp.filter(bufferedImage, null);
        this.setImage(bufferedImage);
        this.setBoundsDirty();
        this.repaint();
    }

    public void temperatureChanged(HeatingElement.ChangeEvent changeEvent) {
        this.setFilteredImage(changeEvent.getHeatingElement());
    }

    public void isEnabledChanged(HeatingElement.ChangeEvent changeEvent) {
        this.setFilteredImage(changeEvent.getHeatingElement());
    }
}

