/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.model;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.ModelEventChannel;
import edu.colorado.phet.common.quantum.model.PhotonEmissionListener;
import edu.colorado.phet.common.quantum.model.PhotonEmittedEvent;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

public class Spectrometer
implements PhotonEmissionListener {
    private Map wavelengthToPhotonNumberMap = new HashMap();
    private boolean isRunning = false;
    private EventChannel changeListenerChannel = new ModelEventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeListenerChannel.getListenerProxy();

    private double getCountAtWavelength(double d) {
        Integer n = (Integer)this.wavelengthToPhotonNumberMap.get(new Double(d));
        return n != null ? n : 0;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
        this.changeListenerProxy.stopped(new StateChangeEvent(this));
    }

    public void start() {
        this.isRunning = true;
        this.changeListenerProxy.started(new StateChangeEvent(this));
    }

    public void reset() {
        this.changeListenerProxy.reset(new StateChangeEvent(this));
        this.wavelengthToPhotonNumberMap.clear();
    }

    public void photonEmitted(PhotonEmittedEvent photonEmittedEvent) {
        if (this.isRunning) {
            Double d = new Double(photonEmittedEvent.getPhoton().getWavelength());
            Integer n = (Integer)this.wavelengthToPhotonNumberMap.get(d);
            int n2 = 0;
            if (n != null) {
                n2 = n;
            }
            this.wavelengthToPhotonNumberMap.put(d, new Integer(++n2));
            this.changeListenerProxy.countChanged(new CountChangeEvent(this, d));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListenerChannel.addListener(changeListener);
    }

    public static interface ChangeListener
    extends EventListener {
        public void countChanged(CountChangeEvent var1);

        public void started(StateChangeEvent var1);

        public void stopped(StateChangeEvent var1);

        public void reset(StateChangeEvent var1);
    }

    public class CountChangeEvent
    extends EventObject {
        private double wavelength;

        public CountChangeEvent(Object object, double d) {
            super(object);
            this.wavelength = d;
        }

        public double getWavelength() {
            return this.wavelength;
        }

        public double getPhotonCount() {
            return ((Spectrometer)this.getSource()).getCountAtWavelength(this.wavelength);
        }
    }

    public class StateChangeEvent
    extends EventObject {
        public StateChangeEvent(Object object) {
            super(object);
        }
    }
}

