/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.model;

import edu.colorado.phet.common.quantum.model.ElementProperties;
import edu.colorado.phet.common.quantum.model.EnergyEmissionStrategy;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;
import edu.colorado.phet.dischargelamps.model.EnergyAbsorptionStrategy;
import edu.colorado.phet.dischargelamps.model.EqualLikelihoodAbsorptionStrategy;
import edu.colorado.phet.dischargelamps.model.LevelSpecificEnergyEmissionStrategy;

public class DischargeLampElementProperties
extends ElementProperties {
    private EnergyAbsorptionStrategy energyAbsorptionStrategy;

    protected DischargeLampElementProperties(String string, double[] dArray, EnergyEmissionStrategy energyEmissionStrategy, EnergyAbsorptionStrategy energyAbsorptionStrategy) {
        this(string, dArray, energyEmissionStrategy, energyAbsorptionStrategy, 0.0);
    }

    protected DischargeLampElementProperties(String string, double[] dArray, EnergyEmissionStrategy energyEmissionStrategy, EnergyAbsorptionStrategy energyAbsorptionStrategy, double d) {
        super(string, dArray, energyEmissionStrategy, d);
        this.setEnergyAbsorptionStrategy(energyAbsorptionStrategy);
    }

    protected DischargeLampElementProperties(String string, double[] dArray, TransitionEntry[] transitionEntryArray) {
        super(string, dArray, new LevelSpecificEnergyEmissionStrategy(transitionEntryArray), DischargeLampAtom.DEFAULT_STATE_LIFETIME);
        this.setEnergyAbsorptionStrategy(new EqualLikelihoodAbsorptionStrategy());
        ((LevelSpecificEnergyEmissionStrategy)this.getEnergyEmissionStrategy()).setStates(this.getStates());
    }

    public EnergyAbsorptionStrategy getEnergyAbsorptionStrategy() {
        return this.energyAbsorptionStrategy;
    }

    public void setEnergyAbsorptionStrategy(EnergyAbsorptionStrategy energyAbsorptionStrategy) {
        this.energyAbsorptionStrategy = energyAbsorptionStrategy;
    }

    public static class TransitionEntry {
        int sourceStateIdx;
        int targetStateIdx;
        double txStrength;

        public TransitionEntry(int n, int n2, double d) {
            this.sourceStateIdx = n;
            this.targetStateIdx = n2;
            this.txStrength = d;
        }

        public int getSourceStateIdx() {
            return this.sourceStateIdx;
        }

        public int getTargetStateIdx() {
            return this.targetStateIdx;
        }

        public double getTxStrength() {
            return this.txStrength;
        }
    }
}

