/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.control;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.control.GraphicSlider;
import edu.colorado.phet.dischargelamps.model.Battery;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BatterySlider
extends GraphicSlider {
    private static final Color DEFAULT_TRACK_COLOR = Color.BLACK;
    private Battery model;
    private double voltageCalibrationFactor;

    public BatterySlider(Component component, int n, Battery battery, double d) {
        this(component, n, 2, DEFAULT_TRACK_COLOR, battery, d);
    }

    public BatterySlider(Component component, int n, int n2, Color color, Battery battery, double d) {
        super(component);
        this.voltageCalibrationFactor = d;
        this.setMaximum(battery.getMaxVoltage() / d);
        this.setMinimum(battery.getMinVoltage() / d);
        this.model = battery;
        this.addChangeListener(new SliderListener());
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component, rectangle, color);
        this.setTrack(phetShapeGraphic);
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, DischargeLampsResources.getImage("sliderKnob.png"));
        phetImageGraphic.centerRegistrationPoint();
        this.setKnob(phetImageGraphic);
        PhetImageGraphic phetImageGraphic2 = new PhetImageGraphic(component, DischargeLampsResources.getImage("sliderKnobHighlight.png"));
        phetImageGraphic2.centerRegistrationPoint();
        this.setKnobHighlight(phetImageGraphic2);
        battery.addChangeListener(new Battery.ChangeListener(){

            public void voltageChanged(Battery.ChangeEvent changeEvent) {
                double d = changeEvent.getVoltageSource().getVoltage();
                if (BatterySlider.this.getValue() != d) {
                    BatterySlider.this.setValue(d * BatterySlider.this.voltageCalibrationFactor);
                }
            }
        });
    }

    private class SliderListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == BatterySlider.this) {
                double d = BatterySlider.this.getValue();
                BatterySlider.this.model.setVoltage(d / BatterySlider.this.voltageCalibrationFactor);
            }
        }
    }
}

