/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.quantum.model;

import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.ElementProperties;
import edu.colorado.phet.common.quantum.model.EnergyEmissionStrategy;
import edu.colorado.phet.common.quantum.model.QuantumModel;

public class PropertiesBasedAtom
extends Atom {
    private EnergyEmissionStrategy energyEmissionStrategy;

    public PropertiesBasedAtom(QuantumModel quantumModel, ElementProperties elementProperties) {
        super(quantumModel, elementProperties.getStates().length, true);
        this.energyEmissionStrategy = elementProperties.getEnergyEmissionStrategy();
        if (elementProperties.getStates().length < 2) {
            throw new RuntimeException("Atom must have at least two states");
        }
        this.setStates(elementProperties.getStates());
        this.setCurrState(elementProperties.getStates()[0]);
    }

    public AtomicState getEnergyStateAfterEmission() {
        return this.energyEmissionStrategy.emitEnergy(this);
    }
}

