/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.collision;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.SolidSphere;
import edu.colorado.phet.common.collision.SphericalBody;

public class SphereSphereContactDetector {
    public boolean applies(Collidable collidable, Collidable collidable2) {
        return collidable instanceof SolidSphere && collidable2 instanceof SolidSphere;
    }

    public boolean areInContact(Collidable collidable, Collidable collidable2) {
        SphericalBody sphericalBody = (SphericalBody)collidable;
        SphericalBody sphericalBody2 = (SphericalBody)collidable2;
        if (this.boundingBoxesOverlap(sphericalBody, sphericalBody2)) {
            return this.spheresOverlap(sphericalBody, sphericalBody2);
        }
        return false;
    }

    private boolean spheresOverlap(SphericalBody sphericalBody, SphericalBody sphericalBody2) {
        double d = sphericalBody.getPosition().distance(sphericalBody2.getPosition());
        return d <= sphericalBody.getRadius() + sphericalBody2.getRadius();
    }

    private boolean boundingBoxesOverlap(SphericalBody sphericalBody, SphericalBody sphericalBody2) {
        return Math.abs(sphericalBody.getPosition().getX() - sphericalBody2.getPosition().getX()) <= sphericalBody.getRadius() + sphericalBody2.getRadius() && Math.abs(sphericalBody.getPosition().getY() - sphericalBody2.getPosition().getY()) <= sphericalBody.getRadius() + sphericalBody2.getRadius();
    }
}

