/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.util.ArrayList;
import java.util.List;

public class PLayer
extends PNode {
    private transient List cameras = new ArrayList();

    public int getCameraCount() {
        if (this.cameras == null) {
            return 0;
        }
        return this.cameras.size();
    }

    public PCamera getCamera(int n) {
        return (PCamera)this.cameras.get(n);
    }

    public void addCamera(PCamera pCamera) {
        this.addCamera(this.cameras.size(), pCamera);
    }

    public void addCamera(int n, PCamera pCamera) {
        this.cameras.add(n, pCamera);
        this.invalidatePaint();
        this.firePropertyChange(8192, "cameras", null, this.cameras);
    }

    public void repaintFrom(PBounds pBounds, PNode pNode) {
        if (pNode != this) {
            this.localToParent(pBounds);
        }
        this.notifyCameras(pBounds);
        if (this.getParent() != null) {
            this.getParent().repaintFrom(pBounds, pNode);
        }
    }

    protected void notifyCameras(PBounds pBounds) {
        int n = this.getCameraCount();
        for (int i = 0; i < n; ++i) {
            PCamera pCamera = (PCamera)this.cameras.get(i);
            pCamera.repaintFromLayer(pBounds, this);
        }
    }
}

