/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.model.mirror;

import edu.colorado.phet.common.collision.Wall;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.lasers.model.mirror.ReflectionStrategy;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Mirror
extends Wall {
    protected ArrayList reflectionStrategies = new ArrayList();

    public Mirror(Point2D point2D, Point2D point2D2) {
        super(new Rectangle2D.Double(point2D.getX(), point2D.getY(), point2D2.getX() - point2D.getY(), point2D2.getY() - point2D.getY()));
        this.setPosition(point2D);
    }

    public void addReflectionStrategy(ReflectionStrategy reflectionStrategy) {
        this.reflectionStrategies.add(reflectionStrategy);
    }

    public boolean reflects(Photon photon) {
        ReflectionStrategy reflectionStrategy;
        boolean bl = true;
        for (int i = 0; i < this.reflectionStrategies.size() && bl; bl &= reflectionStrategy.reflects(photon), ++i) {
            reflectionStrategy = (ReflectionStrategy)this.reflectionStrategies.get(i);
        }
        return bl;
    }
}

