/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.model.collision;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollisionExpert;
import edu.colorado.phet.common.collision.CollisionUtil;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.model.mirror.Mirror;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.Map;

public class PhotonMirrorCollisonExpert
implements CollisionExpert {
    private Class[] classes = new Class[]{Photon.class, Mirror.class};
    private Object[] bodies = new Object[2];
    private Map classifiedBodies = new HashMap();

    public PhotonMirrorCollisonExpert() {
        this.classifiedBodies.put(this.classes[0], null);
        this.classifiedBodies.put(this.classes[1], null);
    }

    public boolean detectAndDoCollision(Collidable collidable, Collidable collidable2) {
        if (CollisionUtil.areConformantToClasses(collidable, collidable2, this.classes[0], this.classes[1])) {
            boolean bl;
            this.bodies[0] = collidable;
            this.bodies[1] = collidable2;
            CollisionUtil.classifyBodies(this.bodies, this.classifiedBodies);
            Mirror mirror = (Mirror)this.classifiedBodies.get(Mirror.class);
            Photon photon = (Photon)this.classifiedBodies.get(Photon.class);
            if (mirror != null && photon != null && (bl = Line2D.linesIntersect(photon.getPositionPrev().getX(), photon.getPositionPrev().getY(), photon.getPosition().getX(), photon.getPosition().getY(), mirror.getPosition().getX(), mirror.getBounds().getMinY(), mirror.getPosition().getX(), mirror.getBounds().getMaxY())) && mirror.reflects(photon) && mirror.reflects(photon)) {
                this.doCollision(photon, mirror);
            }
        }
        return false;
    }

    private void doCollision(Photon photon, Mirror mirror) {
        double d = LasersConfig.PHOTON_CHEAT_ANGLE;
        double d2 = photon.getPosition().getX() - mirror.getPosition().getX();
        photon.setPosition(mirror.getPosition().getX() - d2, photon.getPosition().getY());
        double d3 = 0.0;
        double d4 = 0.0;
        if (Math.abs(photon.getVelocity().getAngle() % Math.PI) < d) {
            d3 = -photon.getVelocity().magnitude() * (double)MathUtil.getSign(photon.getVelocity().getX());
            d4 = 0.0;
        } else {
            d3 = -photon.getVelocity().getX();
            d4 = photon.getVelocity().getY();
        }
        photon.setVelocity(d3, d4);
    }
}

