/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.ClockProfiler;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.OptionsDialog;
import edu.colorado.phet.lasers.controller.module.MultipleAtomModule;
import edu.colorado.phet.lasers.controller.module.SingleAtomModule;
import edu.colorado.phet.lasers.view.AtomGraphic;
import edu.colorado.phet.lasers.view.EnergyLevelGraphic;
import edu.colorado.phet.lasers.view.PhotonGraphic;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LasersApplication
extends PiccoloPhetApplication {
    public static double ONE_ATOM_MODULE_SPEED = 0.5;
    public static double MULTI_ATOM_MODULE_SPEED = 0.5;
    private SingleAtomModule singleAtomModule;
    private MultipleAtomModule multipleAtomModule;

    public LasersApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.getPhetFrame().setResizable(false);
        AtomGraphic.setEnergyRepColorStrategy(new AtomGraphic.VisibleColorStrategy());
        this.singleAtomModule = new SingleAtomModule(this.getPhetFrame(), (IClock)new ConstantDtClock(1000 / LasersConfig.FPS, LasersConfig.DT));
        this.multipleAtomModule = new MultipleAtomModule(this.getPhetFrame(), (IClock)new ConstantDtClock(1000 / LasersConfig.FPS, LasersConfig.DT));
        Module[] moduleArray = new Module[]{this.singleAtomModule, this.multipleAtomModule};
        this.setModules(moduleArray);
        this.addMenuItems();
    }

    private void addEnergyLevelMatchIndicatorRenderDialog() {
        JDialog jDialog = new JDialog(this.getPhetFrame(), "Match Indicator", false);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.add(new JButton(new AbstractAction("Flash Gray"){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyLevelGraphic.setBlinkRenderer(Color.lightGray);
            }
        }));
        verticalLayoutPanel.add(new JButton(new AbstractAction("Flash White"){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyLevelGraphic.setBlinkRenderer(Color.white);
            }
        }));
        verticalLayoutPanel.add(new JButton(new AbstractAction("Flow"){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyLevelGraphic.setFlowRenderer();
            }
        }));
        jDialog.setContentPane(verticalLayoutPanel);
        jDialog.pack();
        SwingUtils.centerDialogInParent(jDialog);
        jDialog.setVisible(true);
    }

    private void addMenuItems() {
        JMenu jMenu = new JMenu(LasersResources.getString("options.menu.title"));
        this.getPhetFrame().addMenu(jMenu);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(LasersResources.getString("options.show-emissions"));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LasersConfig.ENABLE_ALL_STIMULATED_EMISSIONS = jCheckBoxMenuItem.isSelected();
            }
        });
        jCheckBoxMenuItem.setSelected(true);
        jMenu.add(jCheckBoxMenuItem);
        JMenuItem jMenuItem = new JMenuItem(LasersResources.getString("options.adjust-stimulation-likelihood"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final ModelSlider modelSlider = new ModelSlider(LasersResources.getString("options.probability"), "", 0.0, 1.0, 1.0, new DecimalFormat("0.00"));
                modelSlider.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        AtomicState.setStimulationLikelihood(modelSlider.getValue());
                    }
                });
                modelSlider.setValue(AtomicState.getStimulationLikelihood());
                JPanel jPanel = new JPanel();
                jPanel.add(modelSlider);
                PhetOptionPane.showMessageDialog(LasersApplication.this.getPhetFrame(), jPanel);
            }
        });
        jMenu.add(jMenuItem);
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(LasersResources.getString("options.colored-energy-levels"));
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButtonMenuItem.isSelected()) {
                    AtomGraphic.setEnergyRepColorStrategy(new AtomGraphic.VisibleColorStrategy());
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(LasersResources.getString("options.view"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new OptionsDialog(LasersApplication.this).show();
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(LasersResources.getString("options.profile"));
        final ClockProfiler clockProfiler = new ClockProfiler(this.getPhetFrame(), (this.getActiveModule() == null ? this.getModule(0) : this.getActiveModule()).getName(), (ConstantDtClock)(this.getActiveModule() == null ? this.getModule(0) : this.getActiveModule()).getClock());
        this.addModuleObserver(new ModuleObserver(){

            public void moduleAdded(ModuleEvent moduleEvent) {
            }

            public void activeModuleChanged(ModuleEvent moduleEvent) {
                clockProfiler.setModule(LasersApplication.this.getActiveModule().getName(), (ConstantDtClock)LasersApplication.this.getActiveModule().getClock());
            }

            public void moduleRemoved(ModuleEvent moduleEvent) {
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                clockProfiler.show();
            }
        });
    }

    public void setBackgroundColor(Color color) {
        this.singleAtomModule.setBackgroundColor(color);
        this.multipleAtomModule.setBackgroundColor(color);
    }

    public Color getBackgroundColor() {
        return this.singleAtomModule.getBackgroundColor();
    }

    public void setPhotonSize(int n) {
        PhotonGraphic.setPhotonSize(n);
    }

    public int getPhotonSize() {
        return PhotonGraphic.getPhotonSize();
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        if (Arrays.asList(stringArray).indexOf("-selectspeed") >= 0) {
            object2 = JOptionPane.showInputDialog("Enter the speed for the 1st and 2nd panel, separated by whitespace", (Object)(ONE_ATOM_MODULE_SPEED + " " + MULTI_ATOM_MODULE_SPEED));
            object = new StringTokenizer((String)object2);
            ONE_ATOM_MODULE_SPEED = Double.parseDouble(((StringTokenizer)object).nextToken());
            MULTI_ATOM_MODULE_SPEED = Double.parseDouble(((StringTokenizer)object).nextToken());
        }
        object2 = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new LasersApplication(phetApplicationConfig);
            }
        };
        object = new PhetApplicationConfig(stringArray, "lasers");
        ((PhetApplicationConfig)object).setLookAndFeel(new LasersLookAndFeel());
        ((PhetApplicationConfig)object).setFrameSetup(LasersConfig.FRAME_SETUP);
        new PhetApplicationLauncher().launchSim((PhetApplicationConfig)object, (ApplicationConstructor)object2);
    }

    private static class LasersLookAndFeel
    extends PhetLookAndFeel {
        public LasersLookAndFeel() {
            this.setFont(new PhetFont(PhetFont.getDefaultFontSize(), true));
            this.setTitledBorderFont(new PhetFont(PhetFont.getDefaultFontSize(), true));
            this.setBackgroundColor(new Color(138, 156, 148));
            this.setButtonBackgroundColor(new Color(255, 255, 214));
        }
    }
}

