/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.ModelViewTransform1D;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetMultiLineTextGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.SingleAtomModule;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;
import edu.colorado.phet.dischargelamps.quantum.model.Plate;
import edu.colorado.phet.dischargelamps.view.DischargeLampEnergyLevelMonitorPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class CollisionEnergyIndicator
extends CompositePhetGraphic {
    private DischargeLampAtom atom;
    private DischargeLampModel model;
    private ModelViewTransform1D energyYTx;
    private boolean isEnabled = true;

    public CollisionEnergyIndicator(DischargeLampEnergyLevelMonitorPanel dischargeLampEnergyLevelMonitorPanel, SingleAtomModule singleAtomModule) {
        super(dischargeLampEnergyLevelMonitorPanel);
        float f = 10.0f;
        float[] fArray = new float[]{10.0f};
        float f2 = 5.0f;
        float f3 = 1.0f;
        Line2D.Double double_ = new Line2D.Double(25.0, 0.0, 110.0, 0.0);
        Color color = Color.red;
        BasicStroke basicStroke = new BasicStroke(f3);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(dischargeLampEnergyLevelMonitorPanel, double_, basicStroke, color);
        this.addGraphic(phetShapeGraphic);
        Arrow arrow = new Arrow(new Point2D.Double(110.0, 0.0), new Point2D.Double(25.0, 0.0), 8.0, 8.0, 1.0);
        PhetShapeGraphic phetShapeGraphic2 = new PhetShapeGraphic(dischargeLampEnergyLevelMonitorPanel, arrow.getShape(), Color.red);
        this.addGraphic(phetShapeGraphic2);
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic((Component)dischargeLampEnergyLevelMonitorPanel, DischargeLampsResources.getImage("electron.gif"));
        phetImageGraphic.setLocation((int)double_.getBounds().getMaxX() + 5, -3);
        this.addGraphic(phetImageGraphic);
        PhetMultiLineTextGraphic phetMultiLineTextGraphic = new PhetMultiLineTextGraphic((Component)dischargeLampEnergyLevelMonitorPanel, DischargeLampsConfig.DEFAULT_CONTROL_FONT, new String[]{DischargeLampsResources.getString("Misc.energyAt"), DischargeLampsResources.getString("Misc.collision")}, Color.black);
        phetMultiLineTextGraphic.setLocation((int)phetImageGraphic.getBounds().getMaxX() + 5, -8);
        this.addGraphic(phetMultiLineTextGraphic);
        this.model = (DischargeLampModel)singleAtomModule.getModel();
        this.model.addChangeListener(new ModelChangeListener());
        this.atom = (DischargeLampAtom)singleAtomModule.getAtom();
        this.atom.addChangeListener(new AtomChangeListener());
        this.energyYTx = dischargeLampEnergyLevelMonitorPanel.getEnergyYTx();
        dischargeLampEnergyLevelMonitorPanel.addChangeListener(new DischargeLampEnergyLevelMonitorPanel.ChangeListener(){

            public void energyTxChanged(ModelViewTransform1D modelViewTransform1D) {
                CollisionEnergyIndicator.this.energyYTx = modelViewTransform1D;
                CollisionEnergyIndicator.this.update();
            }
        });
        this.update();
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    private void update() {
        double d;
        double d2;
        double d3 = this.model.getVoltage();
        double d4 = this.model.getLeftHandPlate().getPosition().distance(this.model.getRightHandPlate().getPosition()) - 2.0;
        double d5 = 0.0;
        Plate plate = null;
        plate = d3 > 0.0 ? this.model.getLeftHandPlate() : this.model.getRightHandPlate();
        Point2D.Double double_ = new Point2D.Double(this.model.getLeftHandPlate().getPosition().getX(), this.model.getLeftHandPlate().getPosition().getY() + 2.0 + (this.model.getLeftHandPlate().getEndpoints()[1].getY() - this.model.getLeftHandPlate().getEndpoints()[0].getY()) / 2.0);
        Point2D.Double double_2 = new Point2D.Double(this.model.getRightHandPlate().getPosition().getX(), this.model.getRightHandPlate().getPosition().getY() + 2.0 + (this.model.getRightHandPlate().getEndpoints()[1].getY() - this.model.getRightHandPlate().getEndpoints()[0].getY()) / 2.0);
        Line2D.Double double_3 = new Line2D.Double(double_, double_2);
        double d6 = this.atom.getBaseRadius();
        Ellipse2D.Double double_4 = new Ellipse2D.Double(this.atom.getCM().getX() - d6, this.atom.getCM().getY() - d6, d6 * 2.0, d6 * 2.0);
        Point2D[] point2DArray = MathUtil.getLineCircleIntersection(double_4, double_3);
        Point2D.Double double_5 = new Point2D.Double(this.model.getLeftHandPlate().getPosition().getX(), this.model.getLeftHandPlate().getPosition().getY() - 2.0 + (this.model.getLeftHandPlate().getEndpoints()[1].getY() - this.model.getLeftHandPlate().getEndpoints()[0].getY()) / 2.0);
        Point2D.Double double_6 = new Point2D.Double(this.model.getRightHandPlate().getPosition().getX(), this.model.getRightHandPlate().getPosition().getY() - 2.0 + (this.model.getRightHandPlate().getEndpoints()[1].getY() - this.model.getRightHandPlate().getEndpoints()[0].getY()) / 2.0);
        Line2D.Double double_7 = new Line2D.Double(double_5, double_6);
        Point2D[] point2DArray2 = MathUtil.getLineCircleIntersection(double_4, double_7);
        this.setVisible(false);
        double d7 = Double.POSITIVE_INFINITY;
        if (point2DArray[0] != null && point2DArray[1] != null) {
            this.setVisible(true);
            d2 = Math.abs(plate.getPosition().getX() - point2DArray[0].getX());
            d = Math.abs(plate.getPosition().getX() - point2DArray[1].getX());
            d7 = Math.min(d2, d) - 2.0;
        }
        d2 = Double.POSITIVE_INFINITY;
        if (point2DArray2[0] != null && point2DArray2[1] != null) {
            this.setVisible(true);
            d = Math.abs(plate.getPosition().getX() - point2DArray2[0].getX());
            double d8 = Math.abs(plate.getPosition().getX() - point2DArray2[1].getX());
            d2 = Math.min(d, d8) - 2.0;
        }
        d5 = Math.min(d7, d2);
        d = Math.abs(d3) * (d5 / d4);
        int n = this.energyYTx.modelToView(d * 1.0 + this.model.getAtomicStates()[0].getEnergyLevel());
        n = Math.max(n, 10);
        this.setLocation(0, n);
        this.setBoundsDirty();
        this.repaint();
        if (!this.isEnabled) {
            this.setVisible(false);
        }
    }

    private class AtomChangeListener
    extends Atom.ChangeListenerAdapter {
        private AtomChangeListener() {
        }

        public void positionChanged(Atom.ChangeEvent changeEvent) {
            CollisionEnergyIndicator.this.update();
        }
    }

    private class ModelChangeListener
    extends DischargeLampModel.ChangeListenerAdapter {
        private ModelChangeListener() {
        }

        public void voltageChanged(DischargeLampModel.ChangeEvent changeEvent) {
            CollisionEnergyIndicator.this.update();
        }
    }
}

