/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.quantum.view;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.dischargelamps.model.HeatingElement;
import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.awt.image.ShortLookupTable;
import java.io.IOException;

public class PlateGraphic
extends CompositePhetGraphic
implements HeatingElement.ChangeListener {
    private static short[] redLut = new short[256];
    private static short[] greenLut = new short[256];
    private static short[] blueLut = new short[256];
    private static short[] alphaLut = new short[256];
    private static short[][] lutArray = new short[][]{redLut, greenLut, blueLut, alphaLut};
    private static LookupTable table = new ShortLookupTable(0, lutArray);
    private LookupOp temperatureOp = new LookupOp(table, null);
    private BufferedImage image;
    private PhetImageGraphic baseImageGraphic;
    private PhetImageGraphic thermalImageGraphic;
    private BufferedImage thermalImage;

    public PlateGraphic(Component component, double d) {
        super(component);
        try {
            this.image = ImageLoader.loadBufferedImage("discharge-lamps/images/electrode-2.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        double d2 = 1.0;
        double d3 = d / (double)this.image.getHeight();
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d2, d3), 2);
        this.image = affineTransformOp.filter(this.image, null);
        this.baseImageGraphic = new PhetImageGraphic(component, this.image);
        this.thermalImage = this.image;
        this.thermalImageGraphic = new PhetImageGraphic(component, this.thermalImage);
        this.addGraphic(this.baseImageGraphic);
        this.addGraphic(this.thermalImageGraphic);
    }

    private void setFilteredImage(HeatingElement heatingElement) {
        double d = heatingElement.getTemperature();
        for (int i = 0; i < 256; ++i) {
            PlateGraphic.alphaLut[i] = (short)d;
            PlateGraphic.redLut[i] = 255;
        }
        BufferedImage bufferedImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        this.temperatureOp.filter(this.image, bufferedImage);
        ColorModel colorModel = bufferedImage.getColorModel();
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n = this.image.getRGB(i, j);
                int n2 = bufferedImage.getRGB(i, j);
                short s = (short)Math.min(colorModel.getAlpha(n), colorModel.getAlpha(n2));
                int n3 = n2 & 0xFFFFFF | s * 0x1000000;
                bufferedImage.setRGB(i, j, n3);
            }
        }
        this.thermalImageGraphic.setImage(bufferedImage);
        this.setBoundsDirty();
        this.repaint();
    }

    public void temperatureChanged(HeatingElement.ChangeEvent changeEvent) {
        this.setFilteredImage(changeEvent.getHeatingElement());
    }

    public void isEnabledChanged(HeatingElement.ChangeEvent changeEvent) {
        this.setFilteredImage(changeEvent.getHeatingElement());
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PlateGraphic.redLut[i] = (short)i;
            PlateGraphic.greenLut[i] = (short)i;
            PlateGraphic.blueLut[i] = (short)i;
            PlateGraphic.alphaLut[i] = (short)i;
        }
    }
}

