/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.quantum.model;

import edu.colorado.phet.common.collision.SphericalBody;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import java.util.EventListener;
import java.util.EventObject;

public class Electron
extends SphericalBody {
    private EventChannel listenerChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.listenerChannel.getListenerProxy();

    public Electron() {
        this(0.0, 0.0);
    }

    public Electron(double d, double d2) {
        super(2.0);
        this.setMass(9.109E-31);
        this.setRadius(2.0);
        this.setPosition(d, d2);
    }

    public void setVelocity(MutableVector2D mutableVector2D) {
        super.setVelocity(mutableVector2D);
        if (this.changeListenerProxy != null) {
            this.changeListenerProxy.energyChanged(new ChangeEvent(this));
        }
    }

    public void setVelocity(double d, double d2) {
        super.setVelocity(d, d2);
        if (this.changeListenerProxy != null) {
            this.changeListenerProxy.energyChanged(new ChangeEvent(this));
        }
    }

    public double getEnergy() {
        double d = DischargeLampsConfig.PIXELS_PER_NM * DischargeLampsConfig.PIXELS_PER_NM * this.getVelocity().magnitudeSquared() * this.getMass() / 2.0;
        double d2 = d * 6.241418050181001E18;
        return d2;
    }

    public void setEnergy(double d) {
        double d2 = d * 1.6022E-19;
        double d3 = Math.sqrt(2.0 * d2 / this.getMass());
        double d4 = this.getVelocity().magnitude();
        this.setVelocity(this.getVelocity().scale(d3 / d4 / DischargeLampsConfig.PIXELS_PER_NM));
        this.changeListenerProxy.energyChanged(new ChangeEvent(this));
    }

    public void leaveSystem() {
        this.changeListenerProxy.leftSystem(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerChannel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public Electron getElectron() {
            return (Electron)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void leftSystem(ChangeEvent var1);

        public void energyChanged(ChangeEvent var1);
    }

    public static class ChangeListenerAdapter
    implements ChangeListener {
        public void leftSystem(ChangeEvent changeEvent) {
        }

        public void energyChanged(ChangeEvent changeEvent) {
        }
    }
}

