/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.quantum.model;

import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.EventObject;

public abstract class Electrode
extends Particle {
    private double potential;
    private Point2D[] endpoints = new Point2D[2];
    private EventChannel stateChangeEventChannel = new EventChannel(StateChangeListener.class);
    private StateChangeListener stateChangeListenerProxy = (StateChangeListener)this.stateChangeEventChannel.getListenerProxy();

    protected Electrode(Point2D point2D, Point2D point2D2) {
        this.setEndpoints(new Point2D[]{point2D, point2D2});
    }

    public double getPotential() {
        return this.potential;
    }

    public void setPotential(double d) {
        this.potential = d;
        this.stateChangeListenerProxy.potentialChanged(new StateChangeEvent(this));
    }

    protected void setEndpoints(Point2D[] point2DArray) {
        this.endpoints = point2DArray;
        this.setPosition((this.endpoints[0].getX() + this.endpoints[1].getX()) / 2.0, (this.endpoints[0].getY() + this.endpoints[1].getY()) / 2.0);
    }

    public Point2D[] getEndpoints() {
        return this.endpoints;
    }

    public void setPosition(double d, double d2) {
        super.setPosition(d, d2);
    }

    public void setPosition(Point2D point2D) {
        super.setPosition(point2D);
    }

    public void addStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeEventChannel.addListener(stateChangeListener);
    }

    public class StateChangeEvent
    extends EventObject {
        public StateChangeEvent(Object object) {
            super(object);
        }
    }

    public static interface StateChangeListener
    extends EventListener {
        public void potentialChanged(StateChangeEvent var1);
    }
}

