/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;

public abstract class EnergyAbsorptionStrategy {
    public abstract void collideWithElectron(Atom var1, Electron var2);

    public static double getElectronEnergyAtCollision(DischargeLampAtom dischargeLampAtom, Electron electron) {
        double d;
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = electron.getPositionPrev().distanceSq(dischargeLampAtom.getPosition());
        double d6 = (dischargeLampAtom.getBaseRadius() + electron.getRadius()) * (dischargeLampAtom.getBaseRadius() + electron.getRadius());
        double d7 = electron.getPositionPrev().distance(dischargeLampAtom.getPosition()) - electron.getRadius() - dischargeLampAtom.getBaseRadius();
        double d8 = Math.sqrt(d5) - Math.sqrt(d6);
        d8 = d7;
        double d9 = electron.getAcceleration().magnitude() / 2.0;
        double[] dArray = MathUtil.quadraticRoots(d9, d3 = electron.getVelocityPrev().magnitude(), d2 = -d8);
        double d10 = d = dArray[0] >= 0.0 ? dArray[0] : dArray[1];
        if (d < 0.0 || Double.isNaN(d) || Double.isInfinite(d)) {
            d4 = 0.0;
        } else {
            double d11 = electron.getVelocityPrev().magnitude() + electron.getAcceleration().magnitude() * d;
            d4 = DischargeLampsConfig.PIXELS_PER_NM * DischargeLampsConfig.PIXELS_PER_NM * d11 * d11 * electron.getMass() / 2.0 * 6.241418050181001E18;
        }
        return d4;
    }
}

