/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;

public class ElectronPulser
implements ModelElement {
    private double elapsedTime;
    private double duration = 100.0;
    private DischargeLampModel model;

    public ElectronPulser(DischargeLampModel dischargeLampModel, double d) {
        this.model = dischargeLampModel;
        dischargeLampModel.setCurrent(d);
    }

    public void stepInTime(double d) {
        this.elapsedTime += d;
        if (this.elapsedTime >= this.duration) {
            this.model.setCurrent(0.0);
            this.model.removeModelElement(this);
            if (this.model.getVoltage() > 0.0) {
                this.model.getLeftHandPlate().produceElectron();
            } else if (this.model.getVoltage() < 0.0) {
                this.model.getRightHandPlate().produceElectron();
            }
        }
    }
}

