/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.model.clock.TimingStrategy;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.MultipleAtomModule;
import edu.colorado.phet.dischargelamps.SingleAtomModule;
import edu.colorado.phet.lasers.view.AtomGraphic;
import edu.colorado.phet.lasers.view.EnergyLevelGraphic;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DischargeLampsApplication
extends PiccoloPhetApplication {
    public DischargeLampsApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.getPhetFrame().setResizable(false);
        SingleAtomModule singleAtomModule = new SingleAtomModule(DischargeLampsResources.getString("ModuleTitle.SingleAtomModule"), new SwingClock(40, DischargeLampsConfig.DT));
        AtomGraphic.setEnergyRepColorStrategy(new AtomGraphic.GrayScaleStrategy());
        double d = 0.1;
        MultipleAtomModule multipleAtomModule = new MultipleAtomModule(DischargeLampsResources.getString("ModuleTitle.MultipleAtomModule"), new SwingClock(40, DischargeLampsConfig.DT), 30, d);
        this.setModules(new Module[]{singleAtomModule, multipleAtomModule});
        this.setActiveModule(singleAtomModule);
        JMenu jMenu = new JMenu(DischargeLampsResources.getString("menu.options"));
        JMenuItem jMenuItem = new JMenuItem(DischargeLampsResources.getString("simulation.speed"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final IClock iClock = PhetApplication.getInstance().getActiveModule().getClock();
                double d = iClock.getSimulationTimeChange();
                final JSlider jSlider = new JSlider(1, 15, (int)DischargeLampsConfig.DT);
                jSlider.setMajorTickSpacing(2);
                jSlider.setMinorTickSpacing(1);
                jSlider.setPaintTicks(true);
                jSlider.setPaintLabels(true);
                jSlider.setSnapToTicks(true);
                jSlider.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        DischargeLampsConfig.DT = jSlider.getValue();
                        ((Clock)iClock).setTimingStrategy(new TimingStrategy.Constant(jSlider.getValue()));
                    }
                });
                int n = PhetOptionPane.showOKCancelDialog(DischargeLampsApplication.this.getPhetFrame(), jSlider, DischargeLampsResources.getString("simulation.speed"));
                if (n == 2) {
                    ((Clock)iClock).setTimingStrategy(new TimingStrategy.Constant(d));
                }
            }
        });
        jMenu.add(jMenuItem);
        this.getPhetFrame().addMenu(jMenu);
    }

    public static void main(String[] stringArray) {
        EnergyLevelGraphic.showLifetimeLabelText = false;
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new DischargeLampsApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "discharge-lamps");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

