/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.controls.valuecontrol;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractMappingStrategy;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JSlider;
import javax.swing.KeyStroke;

public abstract class AbstractSlider
extends JSlider {
    private AbstractMappingStrategy _strategy;
    private double _upDownArrowDelta;

    protected AbstractSlider(AbstractMappingStrategy abstractMappingStrategy) {
        this._strategy = abstractMappingStrategy;
        this.setMinimum(this._strategy.getSliderMin());
        this.setMaximum(this._strategy.getSliderMax());
        this._upDownArrowDelta = this.getModelRange() / 100.0;
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0, false), "INCREMENT_ACTION");
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0, false), "INCREMENT_ACTION");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSlider.this.setValue(AbstractSlider.this.getValue() + AbstractSlider.this._strategy.modelToSliderDelta(AbstractSlider.this._upDownArrowDelta));
            }
        };
        this.getActionMap().put("INCREMENT_ACTION", abstractAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0, false), "DECREMENT_ACTION");
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0, false), "DECREMENT_ACTION");
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSlider.this.setValue(AbstractSlider.this.getValue() - AbstractSlider.this._strategy.modelToSliderDelta(AbstractSlider.this._upDownArrowDelta));
            }
        };
        this.getActionMap().put("DECREMENT_ACTION", abstractAction2);
    }

    public void setUpDownArrowDelta(double d) {
        this._upDownArrowDelta = d;
    }

    public void setModelValue(double d) {
        int n = this._strategy.modelToSlider(d);
        this.setValue(n);
    }

    public double getModelValue() {
        int n = this.getValue();
        return this.sliderToModel(n);
    }

    public double getModelMin() {
        return this._strategy.getModelMin();
    }

    public double getModelMax() {
        return this._strategy.getModelMax();
    }

    public double getModelRange() {
        return this._strategy.getModelRange();
    }

    public double sliderToModel(int n) {
        return this._strategy.sliderToModel(n);
    }

    public int modelToSlider(double d) {
        return this._strategy.modelToSlider(d);
    }
}

