/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.controls;

import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class HTMLLabel
extends JLabel {
    private Color foreground = this.getForeground();

    public HTMLLabel(String string) {
        super(HTMLUtils.toHTMLString(string));
    }

    public void setForeground(Color color) {
        this.foreground = color;
        this.update();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.update();
    }

    public void setText(String string) {
        super.setText(HTMLUtils.toHTMLString(string));
    }

    private void update() {
        super.setForeground(this.isEnabled() ? this.foreground : this.getDisabledColor());
    }

    private Color getDisabledColor() {
        Color color = UIManager.getColor("Label.disabledText");
        if (color == null) {
            color = Color.GRAY;
        }
        return color;
    }
}

