/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.resources;

import edu.colorado.phet.common.phetcommon.resources.IResourceLoader;
import edu.colorado.phet.common.phetcommon.resources.PhetProperties;
import edu.colorado.phet.common.phetcommon.util.LocaleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

abstract class AbstractResourceLoader
implements IResourceLoader {
    AbstractResourceLoader() {
    }

    public boolean exists(String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        return uRL != null;
    }

    public PhetProperties getProperties(String string, Locale locale) {
        try {
            Properties properties = this.loadProperties(this.getFallbackPropertiesResourceName(string));
            Properties properties2 = this.loadProperties(this.getLocalizedPropertiesResourceName(string, locale));
            properties.putAll((Map<?, ?>)properties2);
            return new PhetProperties(properties);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new PhetProperties(new Properties());
        }
    }

    private Properties loadProperties(String string) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream != null) {
            properties.load(inputStream);
        }
        return properties;
    }

    private String getLocalizedPropertiesResourceName(String string, Locale locale) {
        return this.stripPropertiesSuffix(string) + LocaleUtils.getTranslationFileSuffix(locale) + ".properties";
    }

    private String getFallbackPropertiesResourceName(String string) {
        String string2 = this.stripPropertiesSuffix(string);
        return string2 + ".properties";
    }

    private String stripPropertiesSuffix(String string) {
        if (string.endsWith(".properties")) {
            string = string.substring(0, string.length() - ".properties".length());
        }
        return string;
    }

    public InputStream getResourceAsStream(String string) throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("invalid resource: " + string);
        }
        return inputStream;
    }

    public String getResourceAsString(String string) throws IOException {
        int n;
        InputStream inputStream = this.getResourceAsStream(string);
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            stringBuffer.append(new String(byArray, 0, n));
        }
        return stringBuffer.toString();
    }
}

