/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import java.io.Serializable;

public abstract class AbstractVector2D
implements Serializable {
    public abstract double getX();

    public abstract double getY();

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double magnitudeSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    public double dot(AbstractVector2D abstractVector2D) {
        double d = 0.0;
        d += this.getX() * abstractVector2D.getX();
        return d += this.getY() * abstractVector2D.getY();
    }

    public double getAngle() {
        return Math.atan2(this.getY(), this.getX());
    }

    public Vector2D normalized() {
        double d = this.magnitude();
        if (d == 0.0) {
            throw new UnsupportedOperationException("Cannot normalize a zero-magnitude vector.");
        }
        return new Vector2D(this.getX() / d, this.getY() / d);
    }

    public Vector2D getPerpendicularVector() {
        return new Vector2D(this.getY(), -this.getX());
    }

    public Vector2D minus(double d, double d2) {
        return new Vector2D(this.getX() - d, this.getY() - d2);
    }

    public Vector2D minus(AbstractVector2D abstractVector2D) {
        return this.minus(abstractVector2D.getX(), abstractVector2D.getY());
    }
}

