/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.AbstractTicks;
import edu.colorado.phet.common.charts.Axis;
import edu.colorado.phet.common.charts.DataSetGraphic;
import edu.colorado.phet.common.charts.GridLineSet;
import edu.colorado.phet.common.charts.Orientation;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;

public class Chart
extends GraphicLayerSet {
    private Component component;
    private Range2D range = new Range2D(0.0, 0.0, 1.0, 1.0);
    private ArrayList dataSetGraphics = new ArrayList();
    private Axis xAxis;
    private Axis yAxis;
    private GridLineSet verticalGridlines;
    private GridLineSet horizonalGridlines;
    private TickMarkSet verticalTicks;
    private TickMarkSet horizontalTicks;
    private Paint background = Color.white;
    private ModelViewTransform2D transform;
    private ArrayList listeners = new ArrayList();
    private GraphicLayerSet compositeDataSetGraphic;
    private PhetShapeGraphic backgroundGraphic;
    private PhetShapeGraphic frameGraphic;
    private HTMLGraphic title;
    private Dimension chartSize;

    public Chart(Component component, Range2D range2D, Dimension dimension, double d, double d2, double d3, double d4) {
        super(component);
        this.chartSize = dimension;
        this.component = component;
        this.range.setRange(range2D);
        this.transform = new ModelViewTransform2D(range2D.getBounds(), new Rectangle(dimension));
        this.yAxis = new Axis(this, Orientation.VERTICAL, new BasicStroke(2.0f), Color.black, d3, d4);
        this.verticalTicks = new TickMarkSet(this, Orientation.HORIZONTAL, d3, d4);
        this.verticalGridlines = new GridLineSet(this, Orientation.VERTICAL, d, d2, 0.0);
        this.xAxis = new Axis(this, Orientation.HORIZONTAL, new BasicStroke(2.0f), Color.black, d, d2);
        this.horizontalTicks = new TickMarkSet(this, Orientation.VERTICAL, d, d2);
        this.horizonalGridlines = new GridLineSet(this, Orientation.HORIZONTAL, d3, d4, 0.0);
        this.backgroundGraphic = new PhetShapeGraphic(component, this.getChartBounds(), this.background);
        this.compositeDataSetGraphic = new GraphicLayerSet(component);
        this.frameGraphic = new PhetShapeGraphic(component, this.getChartBounds(), new BasicStroke(1.0f), Color.black);
        this.title = new HTMLGraphic(component, component.getFont(), "Title", Color.black);
        this.title.setVisible(false);
        this.addGraphic(this.backgroundGraphic);
        this.addGraphic(this.verticalGridlines);
        this.addGraphic(this.horizonalGridlines);
        this.addGraphic(this.verticalTicks);
        this.addGraphic(this.horizontalTicks);
        this.addGraphic(this.xAxis);
        this.addGraphic(this.yAxis);
        this.addGraphic(this.compositeDataSetGraphic);
        this.addGraphic(this.frameGraphic);
        this.addGraphic(this.title);
    }

    public Dimension getChartSize() {
        return new Dimension(this.chartSize);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public TickMarkSet getVerticalTicks() {
        return this.verticalTicks;
    }

    public TickMarkSet getHorizontalTicks() {
        return this.horizontalTicks;
    }

    public GridLineSet getVerticalGridlines() {
        return this.verticalGridlines;
    }

    public GridLineSet getHorizonalGridlines() {
        return this.horizonalGridlines;
    }

    public void setRange(Range2D range2D) {
        this.range.setRange(range2D);
        this.transform.setModelBounds(range2D.getBounds());
        this.fireTransformChanged();
        this.autorepaint();
    }

    public Range2D getRange() {
        return new Range2D(this.range);
    }

    public void addDataSetGraphic(DataSetGraphic dataSetGraphic, double d) {
        if (dataSetGraphic.getChart() != null && dataSetGraphic.getChart() != this) {
            throw new RuntimeException("DataSetGraphic was associated with the wrong Chart instance.");
        }
        this.dataSetGraphics.add(dataSetGraphic);
        this.compositeDataSetGraphic.addGraphic(dataSetGraphic, d);
    }

    public Component getComponent() {
        return this.component;
    }

    public Point transform(Point2D point2D) {
        if (point2D == null) {
            throw new RuntimeException("Null point");
        }
        return this.transform.modelToView(point2D);
    }

    public Point transform(double d, double d2) {
        return this.transform(new Point2D.Double(d, d2));
    }

    public Point2D transformDouble(Point2D point2D) {
        if (point2D == null) {
            throw new RuntimeException("Null point");
        }
        return this.transform.modelToViewDouble(point2D);
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public Rectangle getChartBounds() {
        return this.getNetTransform().createTransformedShape(new Rectangle(this.chartSize)).getBounds();
    }

    private void fireTransformChanged() {
        Object object;
        int n;
        for (n = 0; n < this.dataSetGraphics.size(); ++n) {
            object = (DataSetGraphic)this.dataSetGraphics.get(n);
            ((DataSetGraphic)object).transformChanged();
        }
        for (n = 0; n < this.listeners.size(); ++n) {
            object = (Listener)this.listeners.get(n);
            object.transformChanged(this);
        }
    }

    public int transformY(double d) {
        return this.transform((Point2D)new Point2D.Double((double)0.0, (double)d)).y;
    }

    public int transformX(double d) {
        return this.transform((Point2D)new Point2D.Double((double)d, (double)0.0)).x;
    }

    public static class GridTicks
    extends AbstractTicks {
        private int dx = 0;
        private int dy = 0;

        public GridTicks(Chart chart, Orientation orientation, Stroke stroke, Color color, double d) {
            super(chart, orientation, stroke, color, d);
        }

        public int getVerticalTickX() {
            Chart chart = this.getChart();
            return chart.transformX(chart.getRange().getMinX()) + this.dx;
        }

        public int getHorizontalTickY() {
            Chart chart = this.getChart();
            return chart.transformY(chart.getRange().getMinY()) + this.dy;
        }
    }

    public static interface Listener {
        public void transformChanged(Chart var1);
    }

    public static class TickMarkSet
    extends CompositePhetGraphic {
        private GridTicks majorTicks;
        private GridTicks minorTicks;

        public TickMarkSet(Chart chart, Orientation orientation, double d, double d2) {
            super(chart.getComponent());
            this.minorTicks = new GridTicks(chart, orientation, new BasicStroke(2.0f), Color.black, d);
            this.majorTicks = new GridTicks(chart, orientation, new BasicStroke(2.0f), Color.black, d2);
            this.minorTicks.setVisible(false);
            this.addGraphic(this.minorTicks);
            this.addGraphic(this.majorTicks);
            this.setRangeLabelsVisible(false);
        }

        public void setMajorTickLabelsVisible(boolean bl) {
            this.majorTicks.setLabelsVisible(bl);
        }

        public void setMinorTickLabelsVisible(boolean bl) {
            this.minorTicks.setLabelsVisible(bl);
        }

        public void setRangeLabelsVisible(boolean bl) {
            this.majorTicks.setRangeLabelsVisible(bl);
        }

        public void setMajorNumberFormat(NumberFormat numberFormat) {
            this.majorTicks.setNumberFormat(numberFormat);
        }
    }
}

