/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.IOException;
import java.io.InputStream;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.io.BSONInput;
import org.bson.types.ObjectId;

public class BasicBSONDecoder
implements BSONDecoder {
    protected BSONInput _in;
    protected BSONCallback _callback;

    public int decode(InputStream in, BSONCallback callback) throws IOException {
        return this._decode(new BSONInput(in), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _decode(BSONInput in, BSONCallback callback) throws IOException {
        if (this._in != null || this._callback != null) {
            throw new IllegalStateException("not ready");
        }
        this._in = in;
        this._callback = callback;
        if (in.numRead() != 0) {
            throw new IllegalArgumentException("i'm confused");
        }
        try {
            int len = this._in.readInt();
            this._in.setMax(len);
            this._callback.objectStart();
            while (this.decodeElement()) {
            }
            this._callback.objectDone();
            if (this._in.numRead() != len) {
                throw new IllegalArgumentException("bad data.  lengths don't match read:" + this._in.numRead() + " != len:" + len);
            }
            int n = len;
            return n;
        }
        finally {
            this._in = null;
            this._callback = null;
        }
    }

    boolean decodeElement() throws IOException {
        byte type = this._in.read();
        if (type == 0) {
            return false;
        }
        String name = this._in.readCStr();
        switch (type) {
            case 10: {
                this._callback.gotNull(name);
                break;
            }
            case 6: {
                this._callback.gotUndefined(name);
                break;
            }
            case 8: {
                this._callback.gotBoolean(name, this._in.read() > 0);
                break;
            }
            case 1: {
                this._callback.gotDouble(name, this._in.readDouble());
                break;
            }
            case 16: {
                this._callback.gotInt(name, this._in.readInt());
                break;
            }
            case 18: {
                this._callback.gotLong(name, this._in.readLong());
                break;
            }
            case 14: {
                this._callback.gotSymbol(name, this._in.readUTF8String());
                break;
            }
            case 2: {
                this._callback.gotString(name, this._in.readUTF8String());
                break;
            }
            case 7: {
                this._callback.gotObjectId(name, new ObjectId(this._in.readIntBE(), this._in.readIntBE(), this._in.readIntBE()));
                break;
            }
            case 12: {
                this._in.readInt();
                String ns = this._in.readCStr();
                ObjectId theOID = new ObjectId(this._in.readInt(), this._in.readInt(), this._in.readInt());
                this._callback.gotDBRef(name, ns, theOID);
                break;
            }
            case 9: {
                this._callback.gotDate(name, this._in.readLong());
                break;
            }
            case 11: {
                this._callback.gotRegex(name, this._in.readCStr(), this._in.readCStr());
                break;
            }
            case 5: {
                this._binary(name);
                break;
            }
            case 13: {
                this._callback.gotCode(name, this._in.readUTF8String());
                break;
            }
            case 15: {
                this._in.readInt();
                this._callback.gotCodeWScope(name, this._in.readUTF8String(), this._readBasicObject());
                break;
            }
            case 4: {
                this._in.readInt();
                this._callback.arrayStart(name);
                while (this.decodeElement()) {
                }
                this._callback.arrayDone();
                break;
            }
            case 3: {
                this._in.readInt();
                this._callback.objectStart(name);
                while (this.decodeElement()) {
                }
                this._callback.objectDone();
                break;
            }
            case 17: {
                int i = this._in.readInt();
                int time = this._in.readInt();
                this._callback.gotTimestamp(name, time, i);
                break;
            }
            case -1: {
                this._callback.gotMinKey(name);
                break;
            }
            case 127: {
                this._callback.gotMaxKey(name);
                break;
            }
            default: {
                throw new UnsupportedOperationException("BSONDecoder doesn't understand type : " + type + " name: " + name);
            }
        }
        return true;
    }

    protected void _binary(String name) throws IOException {
        int totalLen = this._in.readInt();
        byte bType = this._in.read();
        switch (bType) {
            case 0: {
                byte[] data = new byte[totalLen];
                this._in.fill(data);
                this._callback.gotBinary(name, bType, data);
                return;
            }
            case 2: {
                int len = this._in.readInt();
                if (len + 4 != totalLen) {
                    throw new IllegalArgumentException("bad data size subtype 2 len: " + len + " totalLen: " + totalLen);
                }
                byte[] data = new byte[len];
                this._in.fill(data);
                this._callback.gotBinary(name, bType, data);
                return;
            }
            case 3: {
                if (totalLen != 16) {
                    throw new IllegalArgumentException("bad data size subtype 3 len: " + totalLen + " != 16");
                }
                long part1 = this._in.readLong();
                long part2 = this._in.readLong();
                this._callback.gotUUID(name, part1, part2);
                return;
            }
        }
        byte[] data = new byte[totalLen];
        this._in.fill(data);
        this._callback.gotBinary(name, bType, data);
    }

    Object _readBasicObject() throws IOException {
        BSONCallback _basic;
        this._in.readInt();
        BSONCallback save = this._callback;
        this._callback = _basic = this._callback.createBSONCallback();
        _basic.reset();
        _basic.objectStart(false);
        while (this.decodeElement()) {
        }
        this._callback = save;
        return _basic.get();
    }
}

