/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.controller;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.photoelectric.PhotoelectricResources;
import edu.colorado.phet.photoelectric.controller.BeamControl;
import edu.colorado.phet.photoelectric.model.util.PhotoelectricModelUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class IntensityReadout
extends GraphicLayerSet
implements PhotonSource.RateChangeListener,
BeamControl.BeamChangeListener {
    private Font VALUE_FONT = new Font("SansSerif", 0, 12);
    private DecimalFormat format = new DecimalFormat("#0%");
    private JTextField readout;
    private PhetGraphic readoutGraphic;
    private Beam beam;
    private BeamControl.Mode mode;

    public IntensityReadout(final Component component, final Beam beam) {
        super(component);
        beam.addRateChangeListener(this);
        this.beam = beam;
        this.readout = new JTextField(4);
        this.readout.setHorizontalAlignment(4);
        this.readout.setFont(this.VALUE_FONT);
        this.readout.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                IntensityReadout.this.update(component, beam);
            }
        });
        this.readout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntensityReadout.this.update(component, beam);
            }
        });
        this.readoutGraphic = PhetJComponent.newInstance(component, this.readout);
        this.addGraphic(this.readoutGraphic, 1.0E9);
        this.updateReadout();
    }

    private void update(Component component, Beam beam) {
        try {
            String string = this.readout.getText().toLowerCase();
            int n = string.indexOf("%");
            string = n >= 0 ? this.readout.getText().substring(0, n) : string;
            double d = MathUtil.clamp(0.0, Double.parseDouble(string), 100.0);
            double d2 = d / 100.0 * this.beam.getMaxPhotonsPerSecond();
            this.beam.setPhotonsPerSecond(d2);
        }
        catch (NumberFormatException numberFormatException) {
            PhetOptionPane.showErrorDialog(SwingUtilities.getRoot(component), PhotoelectricResources.getString("Intensity.message"));
            this.readout.setText(this.format.format(beam.getPhotonsPerSecond() / beam.getMaxPhotonsPerSecond()));
        }
    }

    private void updateReadout() {
        double d = this.beam.getPhotonsPerSecond() / this.beam.getMaxPhotonsPerSecond();
        if (this.mode == BeamControl.INTENSITY) {
            d = PhotoelectricModelUtil.photonRateToIntensity(d, this.beam.getWavelength());
        }
        this.readout.setText(this.format.format(d));
    }

    public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
        this.updateReadout();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof BeamControl) {
            this.mode = ((BeamControl)changeEvent.getSource()).getMode();
        }
    }
}

