/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.model.LaserModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class LaserCurtainGraphic
extends PhetShapeGraphic
implements AtomicState.Listener,
LaserModel.ChangeListener {
    private Rectangle beamBounds = new Rectangle();
    private Color color = Color.white;
    private AtomicState[] atomicStates;
    private double level;
    private int numLasingPhotons;
    private double maxAlpha;
    private double alpha;
    private LaserModel model;

    public LaserCurtainGraphic(Component component, Shape shape, LaserModel laserModel, AtomicState[] atomicStateArray, double d) {
        super(component, null, null);
        this.model = laserModel;
        this.atomicStates = atomicStateArray;
        this.maxAlpha = d;
        this.beamBounds.setRect(shape.getBounds());
        this.setShape(shape);
        this.setColor(this.color);
        this.update();
        laserModel.addLaserListener(this);
        atomicStateArray[1].addListener(this);
        atomicStateArray[0].addListener(this);
    }

    public void setMaxAlpha(double d) {
        this.maxAlpha = d;
    }

    private void update() {
        this.level = this.numLasingPhotons > LasersConfig.LASING_THRESHOLD ? (double)this.numLasingPhotons : 0.0;
        this.alpha = this.level / (double)LasersConfig.KABOOM_THRESHOLD * this.maxAlpha;
        double d = this.atomicStates[1].getEnergyLevel() - this.atomicStates[0].getEnergyLevel();
        Color color = VisibleColor.wavelengthToColor(PhysicsUtil.energyToWavelength(d));
        this.setColor(color);
        this.setBoundsDirty();
        this.repaint();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.alpha > 0.0) {
            this.saveGraphicsState(graphics2D);
            GraphicsUtil.setAlpha(graphics2D, this.alpha);
            super.paint(graphics2D);
            this.restoreGraphicsState();
        }
    }

    public void energyLevelChanged(AtomicState.Event event) {
        this.atomicStates[1].removeListener(this);
        this.atomicStates[0].removeListener(this);
        this.atomicStates = new AtomicState[]{this.model.getGroundState(), this.model.getMiddleEnergyState()};
        this.atomicStates[1].addListener(this);
        this.atomicStates[0].addListener(this);
        this.update();
    }

    public void atomicStatesChanged(LaserModel.ChangeEvent changeEvent) {
        this.atomicStates[1].removeListener(this);
        this.atomicStates[0].removeListener(this);
        this.atomicStates = new AtomicState[]{this.model.getGroundState(), this.model.getMiddleEnergyState()};
        this.atomicStates[1].addListener(this);
        this.atomicStates[0].addListener(this);
        this.update();
    }

    public void meanLifetimeChanged(AtomicState.Event event) {
    }

    public void lasingPopulationChanged(LaserModel.ChangeEvent changeEvent) {
        this.numLasingPhotons = changeEvent.getLasingPopulation();
        this.update();
    }
}

