/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.photon;

import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class PhotonNode
extends PhetPNode {
    private static final Color UV_COLOR;
    private static final Color IR_COLOR;
    private static final double SPARKLE_ANGLE;
    private static final Color SPARKLE_COLOR;
    private static final Color UV_SPARKLE_COLOR;
    private static final Color IR_SPARKLE_COLOR;

    public PhotonNode(double d, double d2) {
        this(d, d2, 0.5 * d2, 0.575 * d2);
    }

    public PhotonNode(double d, double d2, double d3, double d4) {
        PNode pNode = new PNode();
        pNode.addChild(new CircleNode(this.getHaloPaint(d, d2), d2));
        pNode.addChild(new CircleNode(this.getOrbPaint(d, d3), d3));
        pNode.addChild(new SparkleNode(this.getSparkleColor(d, d4), d4, SPARKLE_ANGLE));
        PImage pImage = new PImage(pNode.toImage());
        this.addChild(pImage);
        pImage.setOffset(-pImage.getFullBoundsReference().getWidth() / 2.0, -pImage.getFullBoundsReference().getHeight() / 2.0);
    }

    protected Paint getOrbPaint(double d, double d2) {
        Color color = new Color(255, 255, 255, 180);
        Color color2 = ColorUtils.createColor(VisibleColor.wavelengthToColor(d, UV_COLOR, IR_COLOR), 130);
        return new RoundGradientPaint(0.0, 0.0, color, new Point2D.Double(0.25 * d2, 0.25 * d2), color2);
    }

    protected Paint getHaloPaint(double d, double d2) {
        Color color = VisibleColor.wavelengthToColor(d, UV_COLOR, IR_COLOR);
        Color color2 = ColorUtils.createColor(color, 0);
        return new RoundGradientPaint(0.0, 0.0, color, new Point2D.Double(0.4 * d2, 0.4 * d2), color2);
    }

    protected Paint getSparkleColor(double d, double d2) {
        if (d < 380.0) {
            return UV_SPARKLE_COLOR;
        }
        if (d > 780.0) {
            return IR_SPARKLE_COLOR;
        }
        return SPARKLE_COLOR;
    }

    public static Image createImage(double d, double d2) {
        return new PhotonNode(d, d2).toImage();
    }

    static {
        IR_COLOR = UV_COLOR = new Color(160, 160, 160);
        SPARKLE_ANGLE = Math.toRadians(18.0);
        SPARKLE_COLOR = new Color(255, 255, 255, 100);
        UV_SPARKLE_COLOR = VisibleColor.wavelengthToColor(400.0, UV_COLOR, UV_COLOR);
        IR_SPARKLE_COLOR = VisibleColor.wavelengthToColor(715.0, UV_COLOR, UV_COLOR);
    }

    private static class CircleNode
    extends PPath {
        public CircleNode(Paint paint, double d) {
            Ellipse2D.Double double_ = new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d);
            this.setPathTo(double_);
            this.setPaint(paint);
            this.setStroke(null);
        }
    }

    private static class CrosshairsNode
    extends PNode {
        public CrosshairsNode(Paint paint, double d) {
            double d2 = d;
            double d3 = 0.15 * d2;
            Ellipse2D.Double double_ = new Ellipse2D.Double(-d2 / 2.0, -d3 / 2.0, d2, d3);
            PPath pPath = new PPath(double_);
            pPath.setPaint(paint);
            pPath.setStroke(null);
            PPath pPath2 = new PPath(double_);
            pPath2.setPaint(paint);
            pPath2.setStroke(null);
            pPath2.rotate(Math.toRadians(90.0));
            this.addChild(pPath);
            this.addChild(pPath2);
        }
    }

    private static class SparkleNode
    extends PNode {
        public SparkleNode(Paint paint, double d, double d2) {
            CrosshairsNode crosshairsNode = new CrosshairsNode(paint, d);
            CrosshairsNode crosshairsNode2 = new CrosshairsNode(paint, 0.7 * d);
            crosshairsNode2.rotate(Math.toRadians(45.0));
            this.addChild(crosshairsNode2);
            this.addChild(crosshairsNode);
            this.rotate(d2);
        }
    }
}

