/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.lasers.LasersConfig;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public abstract class WaveGraphic
extends PhetGraphic
implements ModelElement {
    private Point2D origin;
    private double extent;
    private double lambda;
    private double period;
    private double amplitude;
    private Color color;
    private double dx = 1.0;
    private GeneralPath wavePath = new GeneralPath();
    private int numPts;
    private double elapsedTime = 0.0;
    private Stroke stroke = new BasicStroke(2.0f);
    private Tube cavity;
    private int level;
    private Rectangle curtainBounds = new Rectangle();
    private int minLevel;
    private double rampUpExponent;

    public WaveGraphic(Component component, Point2D point2D, double d, double d2, double d3, double d4, Color color, Tube tube) {
        super(component);
        this.origin = point2D;
        this.extent = d;
        this.lambda = d2;
        this.period = d3;
        this.amplitude = d4;
        this.cavity = tube;
        this.color = color;
        this.numPts = (int)(d / this.dx) + 1;
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected double getPeriod() {
        return this.period;
    }

    protected double getDx() {
        return this.dx;
    }

    protected GeneralPath getWavePath() {
        return this.wavePath;
    }

    protected int getNumPts() {
        return this.numPts;
    }

    protected double getElapsedTime() {
        return this.elapsedTime;
    }

    protected Rectangle determineBounds() {
        return this.wavePath.getBounds();
    }

    public void paint(Graphics2D graphics2D) {
        this.saveGraphicsState(graphics2D);
        if (this.amplitude > 0.0 && this.isVisible()) {
            graphics2D.setStroke(this.stroke);
            graphics2D.setColor(this.color);
            graphics2D.draw(this.wavePath);
        }
        this.restoreGraphicsState();
    }

    public void stepInTime(double d) {
        this.elapsedTime += d;
    }

    protected void update() {
        this.minLevel = 150;
        this.rampUpExponent = 0.5;
        this.level = Math.max(this.minLevel, 255 - (int)((double)(255 - this.minLevel) * Math.pow(this.getAmplitude() / this.getMaxInternalAmplitude(), this.rampUpExponent)));
        this.level = Math.min(this.level, 255);
        this.curtainBounds.setRect(this.wavePath.getBounds().getMinX(), this.cavity.getBounds().getMinY(), this.wavePath.getBounds().getWidth(), this.cavity.getBounds().getHeight());
        this.setBoundsDirty();
        this.repaint();
    }

    private double getMaxInternalAmplitude() {
        return LasersConfig.LASING_THRESHOLD;
    }
}

