/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.model.mirror;

import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.lasers.model.mirror.ReflectionStrategy;

public class Partial
implements ReflectionStrategy {
    private double reflectivity;

    public Partial(double d) {
        this.reflectivity = d;
    }

    public double getReflectivity() {
        return this.reflectivity;
    }

    public void setReflectivity(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Reflectivity not between 0 and 1.0");
        }
        this.reflectivity = d;
    }

    public boolean reflects(Photon photon) {
        boolean bl = false;
        if (this.reflectivity == 0.0) {
            bl = false;
        } else if (this.reflectivity == 1.0) {
            bl = true;
        } else {
            double d = Math.random();
            if (d < this.reflectivity) {
                bl = true;
            }
        }
        return bl;
    }
}

