/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.dialogs.ColorChooserFactory;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.quantum.model.StimulatedPhoton;
import edu.colorado.phet.lasers.LasersApplication;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.view.PhotonGraphic;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OptionsDialog
extends PaintImmediateDialog {
    private LasersApplication laserApplication;

    public OptionsDialog(final LasersApplication lasersApplication) {
        super(lasersApplication.getPhetFrame(), LasersResources.getString("options.view.title"), false);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setFillNone();
        this.setContentPane(verticalLayoutPanel);
        this.laserApplication = lasersApplication;
        JButton jButton = new JButton(LasersResources.getString("options.background.color"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final Color color = lasersApplication.getBackgroundColor();
                ColorChooserFactory.showDialog(LasersResources.getString("options.background.color"), lasersApplication.getPhetFrame(), lasersApplication.getBackgroundColor(), new ColorChooserFactory.Listener(){

                    public void colorChanged(Color color2) {
                        lasersApplication.setBackgroundColor(color2);
                    }

                    public void ok(Color color2) {
                    }

                    public void cancelled(Color color2) {
                        lasersApplication.setBackgroundColor(color);
                    }
                });
            }
        });
        this.getContentPane().add(jButton);
        final LinearValueControl linearValueControl = new LinearValueControl(1.0, 50.0, LasersResources.getString("options.photon-diameter"), "000", LasersResources.getString("options.pixels"));
        linearValueControl.setValue(lasersApplication.getPhotonSize());
        linearValueControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                lasersApplication.setPhotonSize((int)linearValueControl.getValue());
            }
        });
        this.getContentPane().add(linearValueControl);
        final LinearValueControl linearValueControl2 = new LinearValueControl(1.0, 100.0, LasersResources.getString("options.pair-separation"), "000", "");
        linearValueControl2.setValue(StimulatedPhoton.getSeparation());
        linearValueControl2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                StimulatedPhoton.setSeparation(linearValueControl2.getValue());
            }
        });
        this.getContentPane().add(linearValueControl2);
        final JCheckBox jCheckBox = new JCheckBox(LasersResources.getString("options.comet"), PhotonGraphic.isCometGraphic());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotonGraphic.setCometGraphic(jCheckBox.isSelected());
            }
        });
        this.getContentPane().add(jCheckBox);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }
}

