/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.model;

import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.model.ConfigurableAtomEnergyEmissionStrategy;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;
import edu.colorado.phet.dischargelamps.model.DischargeLampElementProperties;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;
import edu.colorado.phet.dischargelamps.model.EqualLikelihoodAbsorptionStrategy;
import edu.colorado.phet.dischargelamps.quantum.AtomicStateFactory;

public class ConfigurableElementProperties
extends DischargeLampElementProperties {
    private static double[] energyLevels = new double[]{-13.6};
    private double meanStateLifetime = DischargeLampAtom.DEFAULT_STATE_LIFETIME;

    public ConfigurableElementProperties(int n, DischargeLampModel dischargeLampModel) {
        super(DischargeLampsResources.getString("Element.configurable"), energyLevels, new ConfigurableAtomEnergyEmissionStrategy(), new EqualLikelihoodAbsorptionStrategy(), DischargeLampAtom.DEFAULT_STATE_LIFETIME);
        this.setMeanStateLifetime(this.meanStateLifetime);
        dischargeLampModel.addChangeListener(new LevelChangeHandler());
        this.setNumEnergyLevels(n);
    }

    public void setNumEnergyLevels(int n) {
        AtomicState[] atomicStateArray = null;
        atomicStateArray = new AtomicStateFactory().createAtomicStates(n, this.getStates());
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = atomicStateArray[i].getEnergyLevel();
        }
        this.setEnergyLevels(dArray);
        this.setLevelsMovable(true);
    }

    private class LevelChangeHandler
    extends DischargeLampModel.ChangeListenerAdapter {
        private LevelChangeHandler() {
        }

        public void energyLevelsChanged(DischargeLampModel.ChangeEvent changeEvent) {
            if (changeEvent.getDischargeLampModel().getElementProperties() == ConfigurableElementProperties.this) {
                AtomicState[] atomicStateArray = changeEvent.getDischargeLampModel().getAtomicStates();
                double[] dArray = new double[atomicStateArray.length];
                for (int i = 0; i < atomicStateArray.length; ++i) {
                    dArray[i] = atomicStateArray[i].getEnergyLevel();
                }
                ConfigurableElementProperties.this.setEnergyLevels(dArray);
            }
        }
    }
}

