/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.control;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class GraphicSlider
extends GraphicLayerSet {
    private PhetGraphic _knob = null;
    private PhetGraphic _knobHighlight = null;
    private PhetGraphic _track = null;
    private PhetGraphic _background = null;
    private Rectangle _dragBounds = new Rectangle();
    private double _minimum = 0.0;
    private double _maximum = 100.0;
    private double _value = (this._maximum - this._minimum) / 2.0;
    private Dimension _tickSize = new Dimension(1, 12);
    private EventListenerList _listenerList = new EventListenerList();
    private KnobListener _knobListener = new KnobListener();

    public GraphicSlider(Component component) {
        super(component);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setRenderingHints(renderingHints);
    }

    public void setKnob(PhetGraphic phetGraphic) {
        if (this._knob != null) {
            this.removeGraphic(this._knob);
            this._knob.removeCursor();
            this._knob.removeAllMouseInputListeners();
        }
        this._knob = phetGraphic;
        if (this._knob != null) {
            this.addGraphic(phetGraphic, 3.0);
            this._knob.setCursorHand();
            this._knob.addMouseInputListener(this._knobListener);
        }
        this.update();
    }

    public void setKnobHighlight(PhetGraphic phetGraphic) {
        if (this._knobHighlight != null) {
            this.removeGraphic(this._knobHighlight);
        }
        this._knobHighlight = phetGraphic;
        if (this._knobHighlight != null) {
            this.addGraphic(phetGraphic, 4.0);
            this._knobHighlight.setVisible(false);
            this._knobHighlight.setCursorHand();
            this._knobHighlight.addMouseInputListener(this._knobListener);
        }
        this.update();
    }

    public void setTrack(PhetGraphic phetGraphic) {
        if (this._track != null) {
            this.removeGraphic(phetGraphic);
        }
        this._track = phetGraphic;
        this._dragBounds.setBounds(0, 0, 0, 0);
        if (this._track != null) {
            this.addGraphic(phetGraphic, 2.0);
            phetGraphic.setRegistrationPoint(0, 0);
            if (this._background == null) {
                phetGraphic.setLocation(0, 0);
            } else {
                int n = (this._background.getWidth() - phetGraphic.getWidth()) / 2;
                int n2 = (this._background.getHeight() - phetGraphic.getHeight()) / 2;
                phetGraphic.setLocation(n, n2);
            }
            this._dragBounds.setBounds(phetGraphic.getX(), phetGraphic.getY() + phetGraphic.getHeight() / 2, phetGraphic.getWidth(), 1);
        }
        this.setKnob(this._knob);
    }

    public void setValue(double d) {
        if (d != this._value) {
            this._value = MathUtil.clamp(this._minimum, d, this._maximum);
            this.fireChangeEvent(new ChangeEvent(this));
            this.update();
        }
    }

    public double getValue() {
        return this._value;
    }

    public void setMinimum(double d) {
        this._minimum = d;
        this.update();
    }

    public double getMinimum() {
        return this._minimum;
    }

    public void setMaximum(double d) {
        this._maximum = d;
        this.update();
    }

    public double getMaximum() {
        return this._maximum;
    }

    public void addTick(double d) {
        if (this._track != null && d >= this._minimum && d <= this._maximum) {
            Line2D.Double double_ = new Line2D.Double(0.0, 0.0, 0.0, this._tickSize.height);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getComponent());
            phetShapeGraphic.setShape(double_);
            phetShapeGraphic.setBorderColor(Color.BLACK);
            phetShapeGraphic.setStroke(new BasicStroke(this._tickSize.width));
            double d2 = (d - this._minimum) / (this._maximum - this._minimum);
            int n = this._dragBounds.x + (int)(d2 * (double)this._dragBounds.width);
            int n2 = this._dragBounds.y;
            phetShapeGraphic.setLocation(n, n2);
            this.addGraphic(phetShapeGraphic, 1.0);
        }
    }

    private void update() {
        double d = (this._value - this._minimum) / (this._maximum - this._minimum);
        int n = this._dragBounds.x + (int)(d * (double)this._dragBounds.width);
        int n2 = this._dragBounds.y;
        if (this._knob != null) {
            this._knob.setLocation(n, n2);
        }
        if (this._knobHighlight != null) {
            this._knobHighlight.setLocation(n, n2);
        }
        this.repaint();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private class KnobListener
    extends MouseInputAdapter {
        private Point2D _somePoint = new Point2D.Double();
        private Point2D _dragStartPoint = new Point2D.Double();
        private Point2D _knobStartPoint = new Point2D.Double();

        public void mousePressed(MouseEvent mouseEvent) {
            AffineTransform affineTransform = GraphicSlider.this.getNetTransform();
            try {
                Point point = new Point((int)(GraphicSlider.this._knob.getLocation().getX() + GraphicSlider.this.getLocation().getX()), (int)(GraphicSlider.this._knob.getLocation().getY() + GraphicSlider.this.getLocation().getY()));
                affineTransform.inverseTransform(point, this._knobStartPoint);
                affineTransform.inverseTransform(mouseEvent.getPoint(), this._dragStartPoint);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            double d = 0.0;
            try {
                AffineTransform affineTransform = GraphicSlider.this.getNetTransform();
                affineTransform.inverseTransform(mouseEvent.getPoint(), this._somePoint);
                d = this._somePoint.getX();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
            double d2 = d - this._dragStartPoint.getX();
            double d3 = this._knobStartPoint.getX() + d2;
            double d4 = Math.max((double)((GraphicSlider)GraphicSlider.this)._dragBounds.x, Math.min((double)(((GraphicSlider)GraphicSlider.this)._dragBounds.x + ((GraphicSlider)GraphicSlider.this)._dragBounds.width), d3));
            double d5 = (d4 - (double)((GraphicSlider)GraphicSlider.this)._dragBounds.x) / (double)((GraphicSlider)GraphicSlider.this)._dragBounds.width;
            double d6 = d5 * (GraphicSlider.this._maximum - GraphicSlider.this._minimum) + GraphicSlider.this._minimum;
            GraphicSlider.this.setValue(d6);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (GraphicSlider.this._knob != null && GraphicSlider.this._knobHighlight != null && GraphicSlider.this._knob.getBounds().contains(mouseEvent.getPoint())) {
                GraphicSlider.this._knobHighlight.setVisible(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (GraphicSlider.this._knob != null && GraphicSlider.this._knobHighlight != null && !GraphicSlider.this._knobHighlight.getBounds().contains(mouseEvent.getPoint())) {
                GraphicSlider.this._knobHighlight.setVisible(false);
            }
        }
    }
}

