/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.quantum.model;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollidableAdapter;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.EventObject;

public class Photon
extends Particle
implements Collidable {
    public static double DEFAULT_SPEED = 1.0;
    public static double RADIUS = 10.0;
    public static double RED = 680.0;
    public static double DEEP_RED = 640.0;
    public static double BLUE = 440.0;
    public static double MIN_VISIBLE_WAVELENGTH = 380.0;
    public static double MAX_VISIBLE_WAVELENGTH = 710.0;
    public static double GRAY = 5000.0;
    private CollidableAdapter collidableAdapter;
    private double wavelength;
    private EventChannel leftSystemEventChannel = new EventChannel(LeftSystemEventListener.class);
    private LeftSystemEventListener leftSystemListenerProxy = (LeftSystemEventListener)this.leftSystemEventChannel.getListenerProxy();
    private EventChannel velocityChangedEventChannel = new EventChannel(VelocityChangedListener.class);
    private VelocityChangedListener velocityChangedListenerProxy = (VelocityChangedListener)this.velocityChangedEventChannel.getListenerProxy();

    protected Photon() {
        this.collidableAdapter = new CollidableAdapter(this);
        this.setVelocity(DEFAULT_SPEED, 0.0);
    }

    public Photon(Point2D point2D, MutableVector2D mutableVector2D) {
        this();
        this.setPosition(point2D);
        this.setVelocity(mutableVector2D);
    }

    public Photon(double d, Point2D point2D, MutableVector2D mutableVector2D) {
        this(point2D, mutableVector2D);
        this.setWavelength(d);
    }

    public void removeFromSystem() {
        this.leftSystemListenerProxy.leftSystemEventOccurred(new LeftSystemEvent(this));
        this.leftSystemEventChannel.removeAllListeners();
        this.velocityChangedEventChannel.removeAllListeners();
        this.removeAllObservers();
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public void setWavelength(double d) {
        this.wavelength = d;
    }

    public double getEnergy() {
        return PhysicsUtil.wavelengthToEnergy(this.wavelength);
    }

    public void setVelocity(double d, double d2) {
        this.collidableAdapter.updateVelocity();
        super.setVelocity(d, d2);
        if (!this.getVelocity().equals(this.getVelocityPrev())) {
            VelocityChangedEvent velocityChangedEvent = new VelocityChangedEvent();
            this.velocityChangedListenerProxy.velocityChanged(velocityChangedEvent);
        }
    }

    public void setPosition(double d, double d2) {
        this.collidableAdapter.updatePosition();
        super.setPosition(d, d2);
    }

    public void setPosition(Point2D point2D) {
        this.collidableAdapter.updatePosition();
        super.setPosition(point2D);
    }

    public MutableVector2D getVelocityPrev() {
        return this.collidableAdapter.getVelocityPrev();
    }

    public Point2D getPositionPrev() {
        return this.collidableAdapter.getPositionPrev();
    }

    public void addLeftSystemListener(LeftSystemEventListener leftSystemEventListener) {
        this.leftSystemEventChannel.addListener(leftSystemEventListener);
    }

    public void addVelocityChangedListener(VelocityChangedListener velocityChangedListener) {
        this.velocityChangedEventChannel.addListener(velocityChangedListener);
    }

    public static class LeftSystemEvent
    extends EventObject {
        private Photon photon;

        public LeftSystemEvent(Photon photon) {
            super(photon);
            this.photon = photon;
        }

        public Photon getPhoton() {
            return this.photon;
        }
    }

    public static interface LeftSystemEventListener
    extends EventListener {
        public void leftSystemEventOccurred(LeftSystemEvent var1);
    }

    public class VelocityChangedEvent
    extends EventObject {
        public VelocityChangedEvent() {
            super(Photon.this);
        }
    }

    public static interface VelocityChangedListener
    extends EventListener {
        public void velocityChanged(VelocityChangedEvent var1);
    }
}

