/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics.transforms;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.CompositeTransformListener;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ModelViewTransform2D {
    private Rectangle2D.Double modelBounds;
    private Rectangle2D viewBounds;
    private CompositeTransformListener listeners = new CompositeTransformListener();
    private boolean forwardTransformDirty = true;
    private AffineTransform forwardTransform;
    private boolean backTransformDirty = true;
    private boolean invertY;

    public ModelViewTransform2D(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this(rectangle2D, rectangle2D2, true);
    }

    public ModelViewTransform2D(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        this.setModelBounds(rectangle2D);
        this.setViewBounds(rectangle2D2);
        this.invertY = bl;
    }

    public ModelViewTransform2D() {
        this(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0), new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0), false);
    }

    public void setModelBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() <= 0.0 || rectangle2D.getHeight() <= 0.0) {
            throw new RuntimeException("modelBounds dimensions must be > 0 : " + rectangle2D);
        }
        this.modelBounds = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.forwardTransformDirty = true;
        this.backTransformDirty = true;
        this.listeners.transformChanged(this);
    }

    public void setViewBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() <= 0.0 || rectangle2D.getHeight() <= 0.0) {
            throw new RuntimeException("viewBounds dimensions must be > 0 : " + rectangle2D);
        }
        this.forwardTransformDirty = true;
        this.backTransformDirty = true;
        this.viewBounds = rectangle2D;
        this.listeners.transformChanged(this);
    }

    public Point modelToView(Point2D point2D) {
        return ModelViewTransform2D.toPoint(this.modelToViewDouble(point2D));
    }

    public Point2D modelToViewDouble(Point2D point2D) {
        this.fixForwardTransform();
        Point2D point2D2 = this.forwardTransform.transform(point2D, null);
        return point2D2;
    }

    public static AffineTransform createTX(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getWidth() / rectangle2D2.getWidth();
        double d2 = rectangle2D.getX() - d * rectangle2D2.getX();
        double d3 = rectangle2D.getHeight() / rectangle2D2.getHeight();
        double d4 = rectangle2D.getY() - d3 * rectangle2D2.getY();
        return new AffineTransform(d, 0.0, 0.0, d3, d2, d4);
    }

    public static AffineTransform createTXInvertY(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getWidth() / rectangle2D2.getWidth();
        double d2 = -rectangle2D.getHeight() / rectangle2D2.getHeight();
        double d3 = rectangle2D.getX() - d * rectangle2D2.getX();
        double d4 = rectangle2D.getY() + rectangle2D.getHeight() / rectangle2D2.getHeight() * (rectangle2D2.getY() + rectangle2D2.getHeight());
        return new AffineTransform(d, 0.0, 0.0, d2, d3, d4);
    }

    private void fixForwardTransform() {
        if (this.forwardTransformDirty) {
            this.forwardTransform = this.createForwardTransform();
            this.forwardTransformDirty = false;
        }
    }

    protected AffineTransform createForwardTransform() {
        if (this.invertY) {
            return ModelViewTransform2D.createTXInvertY(this.viewBounds, this.modelBounds);
        }
        return ModelViewTransform2D.createTX(this.viewBounds, this.modelBounds);
    }

    public String toString() {
        return "modelBounds=" + this.modelBounds.toString() + ", viewBounds=" + this.viewBounds;
    }

    private static Point toPoint(Point2D point2D) {
        if (point2D instanceof Point) {
            return (Point)point2D;
        }
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }
}

