/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.dialogs;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.dialogs.CreditsDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJButton;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.SoftwareAgreementButton;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.MouseInputAdapter;

public class PhetAboutDialog
extends PaintImmediateDialog {
    private static final String COPYRIGHT_HTML_FRAGMENT = "<b>PhET Interactive Simulations</b><br>Copyright &copy; 2004-2013 University of Colorado.<br><a href=http://phet.colorado.edu/about/licensing.php>Some rights reserved.</a><br>Visit " + HTMLUtils.getPhetHomeHref();
    private static final String TITLE = PhetCommonResources.getString("Common.HelpMenu.AboutTitle");
    private static final String LOGO_TOOLTIP = PhetCommonResources.getString("Common.About.WebLink");
    private static final String SIM_VERSION = PhetCommonResources.getString("Common.About.Version");
    private static final String BUILD_DATE = PhetCommonResources.getString("Common.About.BuildDate");
    private static final String DISTRIBUTION = PhetCommonResources.getString("Common.About.Distribution");
    private static final String JAVA_VERSION = PhetCommonResources.getString("Common.About.JavaVersion");
    private static final String OS_VERSION = PhetCommonResources.getString("Common.About.OSVersion");
    private static final String CREDITS_BUTTON = PhetCommonResources.getString("Common.About.CreditsButton");
    private static final String CLOSE_BUTTON = PhetCommonResources.getString("Common.choice.close");
    private final ISimInfo config;

    public PhetAboutDialog(PhetApplication phetApplication) {
        this((Frame)phetApplication.getPhetFrame(), phetApplication.getSimInfo());
    }

    protected PhetAboutDialog(Frame frame, ISimInfo iSimInfo) {
        super(frame);
        this.setResizable(false);
        this.config = iSimInfo;
        String string = iSimInfo.getName();
        this.setTitle(TITLE + " " + string);
        JPanel jPanel = this.createLogoPanel();
        JPanel jPanel2 = this.createInfoPanel(iSimInfo);
        JPanel jPanel3 = this.createButtonPanel(iSimInfo.isStatisticsFeatureIncluded());
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setFillHorizontal();
        verticalLayoutPanel.add(jPanel);
        verticalLayoutPanel.add(new JSeparator());
        verticalLayoutPanel.add(jPanel2);
        verticalLayoutPanel.add(new JSeparator());
        verticalLayoutPanel.add(jPanel3);
        this.setContentPane(verticalLayoutPanel);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private JPanel createLogoPanel() {
        BufferedImage bufferedImage = PhetCommonResources.getInstance().getImage("logos/phet-logo-120x50.jpg");
        JLabel jLabel = new JLabel(new ImageIcon(bufferedImage));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.setToolTipText(LOGO_TOOLTIP);
        jLabel.addMouseListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                PhetServiceManager.showPhetPage();
            }
        });
        String string = HTMLUtils.createStyledHTMLFromFragment(COPYRIGHT_HTML_FRAGMENT);
        HTMLUtils.InteractiveHTMLPane interactiveHTMLPane = new HTMLUtils.InteractiveHTMLPane(string);
        interactiveHTMLPane.setBackground(new JPanel().getBackground());
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        horizontalLayoutPanel.setInsets(new Insets(10, 10, 10, 10));
        horizontalLayoutPanel.add(jLabel);
        horizontalLayoutPanel.add(interactiveHTMLPane);
        return horizontalLayoutPanel;
    }

    private JPanel createInfoPanel(ISimInfo iSimInfo) {
        String string = iSimInfo.getName();
        String string2 = iSimInfo.getVersion().formatForAboutDialog();
        String string3 = iSimInfo.getVersion().formatTimestamp();
        String string4 = iSimInfo.getDistributionTag();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getFontName(), 1, font.getSize()));
        JLabel jLabel2 = new JLabel(SIM_VERSION + " " + string2);
        JLabel jLabel3 = new JLabel(BUILD_DATE + " " + string3);
        JLabel jLabel4 = null;
        if (string4 != null && string4.length() > 0) {
            jLabel4 = new JLabel(DISTRIBUTION + " " + string4);
        }
        String string5 = JAVA_VERSION + " " + System.getProperty("java.version");
        JLabel jLabel5 = new JLabel(string5);
        String string6 = OS_VERSION + " " + System.getProperty("os.name") + " " + System.getProperty("os.version");
        JLabel jLabel6 = new JLabel(string6);
        int n = 10;
        int n2 = 10;
        verticalLayoutPanel.setInsets(new Insets(0, n, 0, n));
        verticalLayoutPanel.add(Box.createVerticalStrut(n2));
        verticalLayoutPanel.add(jLabel);
        verticalLayoutPanel.add(Box.createVerticalStrut(n2));
        verticalLayoutPanel.add(jLabel2);
        verticalLayoutPanel.add(jLabel3);
        if (jLabel4 != null) {
            verticalLayoutPanel.add(jLabel4);
        }
        verticalLayoutPanel.add(Box.createVerticalStrut(n2));
        verticalLayoutPanel.add(jLabel5);
        verticalLayoutPanel.add(jLabel6);
        verticalLayoutPanel.add(Box.createVerticalStrut(n2));
        return verticalLayoutPanel;
    }

    private JPanel createButtonPanel(boolean bl) {
        SoftwareAgreementButton softwareAgreementButton = new SoftwareAgreementButton(this);
        SimSharingJButton simSharingJButton = new SimSharingJButton(UserComponents.aboutDialogCreditsButton, CREDITS_BUTTON);
        simSharingJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhetAboutDialog.this.showCredits();
            }
        });
        SimSharingJButton simSharingJButton2 = new SimSharingJButton(UserComponents.aboutDialogCloseButton, CLOSE_BUTTON);
        this.getRootPane().setDefaultButton(simSharingJButton2);
        simSharingJButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhetAboutDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(softwareAgreementButton);
        jPanel.add(simSharingJButton);
        jPanel.add(simSharingJButton2);
        return jPanel;
    }

    protected void showCredits() {
        new CreditsDialog((Dialog)this, this.config.getProjectName()).setVisible(true);
    }
}

