/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.module;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.PhotonEmissionListener;
import edu.colorado.phet.common.quantum.model.PhotonEmittedEvent;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.control.BatterySlider;
import edu.colorado.phet.dischargelamps.model.Battery;
import edu.colorado.phet.dischargelamps.view.BatteryReadout;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.view.BeamCurtainGraphic;
import edu.colorado.phet.lasers.view.LampGraphic;
import edu.colorado.phet.lasers.view.TubeGraphic;
import edu.colorado.phet.photoelectric.PhotoelectricApplication;
import edu.colorado.phet.photoelectric.PhotoelectricConfig;
import edu.colorado.phet.photoelectric.PhotoelectricResources;
import edu.colorado.phet.photoelectric.controller.BeamControl;
import edu.colorado.phet.photoelectric.controller.PhotoelectricControlPanel;
import edu.colorado.phet.photoelectric.model.PhotoelectricModel;
import edu.colorado.phet.photoelectric.model.PhotoelectricTarget;
import edu.colorado.phet.photoelectric.view.AmmeterView;
import edu.colorado.phet.photoelectric.view.AmmeterViewGraphic;
import edu.colorado.phet.photoelectric.view.ElectronGraphicManager;
import edu.colorado.phet.photoelectric.view.IntensityView;
import edu.colorado.phet.photoelectric.view.PhotoelectricPlateGraphic;
import edu.colorado.phet.photoelectric.view.PhotonGraphicManager;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;

public class PhotoelectricModule
extends BaseLaserModule {
    private static HashMap TARGET_COLORS = new HashMap();
    public static boolean DEBUG;
    private PhotoelectricTarget targetPlate;
    private double externalGraphicsScale;
    private AffineTransformOp externalGraphicScaleOp;
    private BeamCurtainGraphic beamGraphic;
    private int viewType = 1;
    private PhetImageGraphic circuitGraphic;
    private BufferedImage circuitImageA;
    private BufferedImage circuitImageB;
    private BeamControl beamControl;

    public PhotoelectricModule(PhetFrame phetFrame, PhotoelectricApplication photoelectricApplication) {
        super(phetFrame, PhotoelectricResources.getString("ModuleTitle.PhotoelectricEfect"), new SwingClock(40, 12.0), Photon.DEFAULT_SPEED);
        Object object;
        IClock iClock = this.getClock();
        ApparatusPanel3 apparatusPanel3 = new ApparatusPanel3(iClock, 746, 552);
        apparatusPanel3.setPaintStrategy(2);
        apparatusPanel3.setBackground(Color.white);
        this.setApparatusPanel(apparatusPanel3);
        PhotoelectricModel photoelectricModel = new PhotoelectricModel(iClock);
        this.setModel(photoelectricModel);
        this.setControlPanel(new ControlPanel(this));
        photoelectricModel.getTarget().setTargetMaterial(PhotoelectricTarget.SODIUM);
        this.addTubeGraphic(photoelectricModel, this.getApparatusPanel());
        Beam beam = photoelectricModel.getBeam();
        this.addBeamGraphic(beam);
        beam.addPhotonEmittedListener(new PhotonPlacementManager());
        beam.addPhotonEmittedListener(new PhotonGraphicManager(this));
        PhotoelectricTarget photoelectricTarget = photoelectricModel.getTarget();
        photoelectricTarget.addListener(new ElectronGraphicManager(this));
        this.addCircuitGraphic(apparatusPanel3);
        this.addTargetGraphic(photoelectricModel, apparatusPanel3);
        this.addAnodeGraphic(photoelectricModel, apparatusPanel3);
        Rectangle rectangle = new Rectangle(0, 0, DischargeLampsConfig.CATHODE_LOCATION.x, 2000);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getApparatusPanel(), rectangle, this.getApparatusPanel().getBackground());
        this.getApparatusPanel().addGraphic(phetShapeGraphic, 901.0);
        photoelectricModel.addChangeListener(new BatteryImageFlipper());
        new PhotoelectricControlPanel(this);
        this.addGraphicBatteryControls();
        this.beamControl = new BeamControl(this.getApparatusPanel(), PhotoelectricConfig.BEAM_CONTROL_LOCATION, photoelectricModel.getBeam(), photoelectricModel.getBeam().getMaxPhotonsPerSecond());
        this.getApparatusPanel().addGraphic(this.beamControl, 901.0);
        Object object2 = new AmmeterViewGraphic(this.getApparatusPanel(), this.getPhotoelectricModel().getAmmeter(), this.getPhotoelectricModel());
        ((PhetGraphic)object2).setLocation(DischargeLampsConfig.ANODE_LOCATION.x - 100, DischargeLampsConfig.ANODE_LOCATION.y + 188);
        this.getApparatusPanel().addGraphic((PhetGraphic)object2, 2000.0);
        if (DEBUG) {
            object2 = photoelectricApplication.getOptionsMenu();
            object = new JCheckBoxMenuItem("Show meters");
            ((JMenu)object2).add((JMenuItem)object);
            final JDialog jDialog = new JDialog((Frame)PhetApplication.getInstance().getPhetFrame(), false);
            AmmeterView ammeterView = new AmmeterView(this.getPhotoelectricModel().getAmmeter());
            IntensityView intensityView = new IntensityView(this.getPhotoelectricModel().getBeamIntensityMeter());
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            jDialog.setContentPane(jPanel);
            jPanel.add(ammeterView);
            jPanel.add(intensityView);
            jDialog.pack();
            ((AbstractButton)object).addActionListener(new ActionListener((JCheckBoxMenuItem)object){
                final /* synthetic */ JCheckBoxMenuItem val$currentDisplayMI;
                {
                    this.val$currentDisplayMI = jCheckBoxMenuItem;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.setVisible(this.val$currentDisplayMI.isSelected());
                }
            });
            AmmeterViewGraphic ammeterViewGraphic = new AmmeterViewGraphic(this.getApparatusPanel(), this.getPhotoelectricModel().getAmmeter(), this.getPhotoelectricModel());
            ammeterViewGraphic.setLocation(DischargeLampsConfig.ANODE_LOCATION.x - 100, DischargeLampsConfig.ANODE_LOCATION.y + 188);
            this.getApparatusPanel().addGraphic(ammeterViewGraphic, 2000.0);
            final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Uniform electron speeds");
            ((JMenu)object2).addSeparator();
            ((JMenu)object2).add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jRadioButtonMenuItem.isSelected()) {
                        PhotoelectricModule.this.getPhotoelectricModel().getTarget().setUniformInitialElectronSpeedStrategy();
                    }
                }
            });
            final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Randomized electron speeds");
            ((JMenu)object2).add(jRadioButtonMenuItem2);
            jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jRadioButtonMenuItem2.isSelected()) {
                        PhotoelectricModule.this.getPhotoelectricModel().getTarget().setRandomizedInitialElectronSpeedStrategy();
                    }
                }
            });
            ((JMenu)object2).addSeparator();
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem2);
            jRadioButtonMenuItem.setSelected(true);
        }
        if (DEBUG) {
            object2 = new PhetShapeGraphic(this.getApparatusPanel(), new Ellipse2D.Double(beam.getPosition().getX(), beam.getPosition().getY(), 10.0, 10.0), Color.red);
            this.getApparatusPanel().addGraphic((PhetGraphic)object2, 10000.0);
            object = new PhetShapeGraphic(this.getApparatusPanel(), new Ellipse2D.Double(this.targetPlate.getPosition().getX(), this.targetPlate.getPosition().getY(), 10.0, 10.0), Color.red);
            this.getApparatusPanel().addGraphic((PhetGraphic)object, 10000.0);
        }
    }

    protected JComponent createClockControlPanel(IClock iClock) {
        return new PiccoloClockControlPanel(iClock);
    }

    private void addBeamGraphic(Beam beam) {
        BufferedImage bufferedImage = PhotoelectricResources.getImage("flashlight.png");
        AffineTransform affineTransform = AffineTransform.getScaleInstance(100.0 / (double)bufferedImage.getWidth(), beam.getBeamWidth() / (double)bufferedImage.getHeight());
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        bufferedImage = affineTransformOp.filter(bufferedImage, null);
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(beam.getDirection(), beam.getPosition().getX(), beam.getPosition().getY());
        affineTransform2.concatenate(AffineTransform.getTranslateInstance(beam.getPosition().getX() - (double)bufferedImage.getWidth(), beam.getPosition().getY() - (double)(bufferedImage.getHeight() / 2)));
        LampGraphic lampGraphic = new LampGraphic(beam, this.getApparatusPanel(), bufferedImage, affineTransform2);
        this.getApparatusPanel().addGraphic(lampGraphic, 1000.0);
        Rectangle rectangle = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getApparatusPanel(), rectangle, this.getApparatusPanel().getBackground());
        phetShapeGraphic.setTransform(affineTransform2);
        phetShapeGraphic.setLocation(lampGraphic.getLocation());
        this.getApparatusPanel().addGraphic(phetShapeGraphic, 900.5);
        this.beamGraphic = new BeamCurtainGraphic(this.getApparatusPanel(), beam);
        this.getApparatusPanel().addGraphic(this.beamGraphic, 900.0);
    }

    private void addGraphicBatteryControls() {
        Battery battery = this.getPhotoelectricModel().getBattery();
        BatterySlider batterySlider = new BatterySlider(this.getApparatusPanel(), 80, battery, 1.0);
        batterySlider.setMinimum((int)(-battery.getMaxVoltage()));
        batterySlider.setMaximum((int)battery.getMaxVoltage());
        batterySlider.setValue(0.0);
        batterySlider.addTick(batterySlider.getMinimum());
        batterySlider.addTick(batterySlider.getMaximum());
        batterySlider.addTick(0.0);
        int n = 490;
        batterySlider.setLocation((int)DischargeLampsConfig.CATHODE_LOCATION.getX() + 174, n);
        this.getApparatusPanel().addGraphic(batterySlider, 10120.0);
        BatteryReadout batteryReadout = new BatteryReadout(this.getApparatusPanel(), battery, new Point((int)DischargeLampsConfig.CATHODE_LOCATION.getX() + 194, n + 15), 35);
        this.addGraphic(batteryReadout, 10120.0);
    }

    private void addCircuitGraphic(ApparatusPanel apparatusPanel) {
        this.circuitImageA = PhotoelectricResources.getImage("circuit-A.png");
        this.circuitImageB = PhotoelectricResources.getImage("circuit-B.png");
        this.circuitImageA = this.scaleImage(this.circuitImageA);
        this.circuitImageB = this.scaleImage(this.circuitImageB);
        this.circuitGraphic = new PhetImageGraphic(this.getApparatusPanel());
        this.circuitGraphic.setImage(this.circuitImageA);
        this.circuitGraphic.setRegistrationPoint((int)(124.0 * this.externalGraphicsScale), (int)(110.0 * this.externalGraphicsScale));
        this.circuitGraphic.setLocation(DischargeLampsConfig.CATHODE_LOCATION);
        apparatusPanel.addGraphic(this.circuitGraphic, 1999.0);
    }

    private void addTubeGraphic(PhotoelectricModel photoelectricModel, ApparatusPanel apparatusPanel) {
        Tube tube = photoelectricModel.getTube();
        TubeGraphic tubeGraphic = new TubeGraphic(this.getApparatusPanel(), tube);
        apparatusPanel.addGraphic(tubeGraphic, 2000.0);
    }

    private void addAnodeGraphic(PhotoelectricModel photoelectricModel, ApparatusPanel apparatusPanel) {
        PhotoelectricPlateGraphic photoelectricPlateGraphic = new PhotoelectricPlateGraphic(this.getApparatusPanel(), 200.0, photoelectricModel, PhotoelectricPlateGraphic.POSITIVE);
        photoelectricPlateGraphic.setRegistrationPoint((int)photoelectricPlateGraphic.getBounds().getWidth(), (int)photoelectricPlateGraphic.getBounds().getHeight() / 2);
        photoelectricPlateGraphic.setRegistrationPoint(0, (int)photoelectricPlateGraphic.getBounds().getHeight() / 2);
        photoelectricPlateGraphic.setLocation(DischargeLampsConfig.ANODE_LOCATION);
        apparatusPanel.addGraphic(photoelectricPlateGraphic, 1999.0);
    }

    private void addTargetGraphic(PhotoelectricModel photoelectricModel, ApparatusPanel apparatusPanel) {
        this.targetPlate = photoelectricModel.getTarget();
        PhotoelectricPlateGraphic photoelectricPlateGraphic = new PhotoelectricPlateGraphic(this.getApparatusPanel(), 200.0, photoelectricModel, PhotoelectricPlateGraphic.NEGATIVE);
        photoelectricPlateGraphic.setRegistrationPoint((int)photoelectricPlateGraphic.getBounds().getWidth(), (int)photoelectricPlateGraphic.getBounds().getHeight() / 2);
        photoelectricPlateGraphic.setLocation(DischargeLampsConfig.CATHODE_LOCATION);
        apparatusPanel.addGraphic(photoelectricPlateGraphic, 1999.0);
        double d = 5.0;
        double d2 = 7.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(photoelectricPlateGraphic.getBounds().getMaxX(), photoelectricPlateGraphic.getBounds().getMinY() + d, d2, photoelectricPlateGraphic.getBounds().getHeight() - 2.0 * d);
        Color color = (Color)TARGET_COLORS.get(this.targetPlate.getMaterial());
        final PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getApparatusPanel(), double_, color);
        this.getApparatusPanel().addGraphic(phetShapeGraphic, 1999.0);
        photoelectricModel.addChangeListener(new PhotoelectricModel.ChangeListenerAdapter(){

            public void targetMaterialChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                phetShapeGraphic.setPaint((Paint)TARGET_COLORS.get(PhotoelectricModule.this.targetPlate.getMaterial()));
            }
        });
    }

    private PhotoelectricModel getPhotoelectricModel() {
        return (PhotoelectricModel)this.getModel();
    }

    private BufferedImage scaleImage(BufferedImage bufferedImage) {
        if (this.externalGraphicScaleOp == null) {
            int n = 550;
            this.determineExternalGraphicScale(DischargeLampsConfig.ANODE_LOCATION, DischargeLampsConfig.CATHODE_LOCATION, n);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(this.externalGraphicsScale, this.externalGraphicsScale);
            this.externalGraphicScaleOp = new AffineTransformOp(affineTransform, 2);
        }
        return this.externalGraphicScaleOp.filter(bufferedImage, null);
    }

    private void determineExternalGraphicScale(Point point, Point point2, int n) {
        this.externalGraphicsScale = point.distance(point2) / (double)n;
    }

    public boolean hasHelp() {
        return false;
    }

    public void setPhotonViewEnabled(boolean bl) {
        this.viewType = bl ? 2 : 1;
        this.beamGraphic.setVisible(!bl);
    }

    public boolean getPhotonViewEnabled() {
        return this.viewType == 2;
    }

    public BeamControl getBeamControl() {
        return this.beamControl;
    }

    static {
        TARGET_COLORS.put(PhotoelectricTarget.COPPER, new Color(210, 130, 30));
        TARGET_COLORS.put(PhotoelectricTarget.MAGNESIUM, new Color(130, 150, 170));
        TARGET_COLORS.put(PhotoelectricTarget.SODIUM, new Color(160, 180, 160));
        TARGET_COLORS.put(PhotoelectricTarget.ZINC, new Color(200, 200, 200));
        TARGET_COLORS.put(PhotoelectricTarget.PLATINUM, new Color(203, 230, 230));
        TARGET_COLORS.put(PhotoelectricTarget.CALCIUM, new Color(0, 0, 0));
        DEBUG = false;
    }

    private class BatteryImageFlipper
    extends PhotoelectricModel.ChangeListenerAdapter {
        private BatteryImageFlipper() {
        }

        public void voltageChanged(PhotoelectricModel.ChangeEvent changeEvent) {
            PhotoelectricModel photoelectricModel = changeEvent.getPhotoelectricModel();
            if (photoelectricModel.getVoltage() > 0.0 && PhotoelectricModule.this.circuitGraphic.getImage() != PhotoelectricModule.this.circuitImageA) {
                PhotoelectricModule.this.circuitGraphic.setImage(PhotoelectricModule.this.circuitImageA);
            } else if (photoelectricModel.getVoltage() < 0.0 && PhotoelectricModule.this.circuitGraphic.getImage() != PhotoelectricModule.this.circuitImageB) {
                PhotoelectricModule.this.circuitGraphic.setImage(PhotoelectricModule.this.circuitImageB);
            }
        }
    }

    private class PhotonPlacementManager
    implements PhotonEmissionListener {
        private PhotonPlacementManager() {
        }

        public void photonEmitted(PhotonEmittedEvent photonEmittedEvent) {
            if (PhotoelectricModule.this.viewType == 1) {
                Photon photon = photonEmittedEvent.getPhoton();
                Line2D.Double double_ = new Line2D.Double(photon.getPosition().getX(), photon.getPosition().getY(), photon.getPosition().getX() + photon.getVelocity().getX(), photon.getPosition().getY() + photon.getVelocity().getY());
                Point2D.Double double_2 = MathUtil.getLinesIntersection(((Line2D)double_).getP1(), ((Line2D)double_).getP2(), PhotoelectricModule.this.targetPlate.getEndpoints()[0], PhotoelectricModule.this.targetPlate.getEndpoints()[1]);
                photon.setPosition(((Point2D)double_2).getX() - photon.getVelocity().getX(), ((Point2D)double_2).getY() - photon.getVelocity().getY());
            }
        }
    }
}

