/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.model.util;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.ModelEventChannel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.Timer;

public class ScalarDataRecorder {
    private List dataRecord = new ArrayList();
    private double dataTotal;
    private double dataAverage;
    private double timeWindow;
    private double timeSpanOfEntries;
    private IClock clock;
    private PeriodicDataComputer periodicDataComputer;
    private double minVal;
    private double maxVal;
    private EventChannel updateListenerChannel = new ModelEventChannel(UpdateListener.class);
    private UpdateListener updateListenerProxy = (UpdateListener)this.updateListenerChannel.getListenerProxy();

    public ScalarDataRecorder(IClock iClock) {
        this.clock = iClock;
    }

    protected synchronized void computeDataStatistics() {
        double d = this.clock.getSimulationTime();
        if (this.dataRecord.size() > 0) {
            double d2 = ((DataRecordEntry)this.dataRecord.get(0)).getTime();
            while (this.dataRecord.size() > 0 && d - d2 > this.timeWindow) {
                this.dataRecord.remove(0);
                if (this.dataRecord.size() <= 0) continue;
                d2 = ((DataRecordEntry)this.dataRecord.get(0)).getTime();
            }
        }
        this.dataTotal = 0.0;
        this.minVal = Double.MAX_VALUE;
        this.maxVal = Double.MIN_VALUE;
        for (int i = 0; i < this.dataRecord.size(); ++i) {
            DataRecordEntry dataRecordEntry = (DataRecordEntry)this.dataRecord.get(i);
            this.dataTotal += dataRecordEntry.getValue();
            this.minVal = this.minVal > dataRecordEntry.getValue() ? dataRecordEntry.getValue() : this.minVal;
            this.maxVal = this.maxVal < dataRecordEntry.getValue() ? dataRecordEntry.getValue() : this.maxVal;
        }
        this.dataAverage = 0.0;
        if (this.dataRecord.size() > 0) {
            double d3 = ((DataRecordEntry)this.dataRecord.get(0)).getTime();
            double d4 = ((DataRecordEntry)this.dataRecord.get(this.dataRecord.size() - 1)).getTime();
            this.timeSpanOfEntries = d4 - d3;
            this.dataAverage = this.dataTotal / (double)this.dataRecord.size();
        }
    }

    public synchronized void addDataRecordEntry(double d) {
        DataRecordEntry dataRecordEntry = new DataRecordEntry(this.clock.getSimulationTime(), d);
        this.dataRecord.add(dataRecordEntry);
    }

    public void setTimeWindow(double d) {
        this.timeWindow = d;
    }

    public void setClientUpdateInterval(int n) {
        if (this.periodicDataComputer != null) {
            this.periodicDataComputer.stop();
        }
        this.periodicDataComputer = new PeriodicDataComputer(n);
        this.periodicDataComputer.start();
    }

    public double getDataTotal() {
        return this.dataTotal;
    }

    public double getTimeSpanOfEntries() {
        return this.timeSpanOfEntries;
    }

    public void addUpdateListener(UpdateListener updateListener) {
        this.updateListenerChannel.addListener(updateListener);
    }

    private class DataRecordEntry {
        private double time;
        private double value;

        DataRecordEntry(double d, double d2) {
            this.time = d;
            this.value = d2;
        }

        public double getTime() {
            return this.time;
        }

        public double getValue() {
            return this.value;
        }
    }

    private class PeriodicDataComputer {
        Timer timer;

        PeriodicDataComputer(int n) {
            this.timer = new Timer(n, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    ScalarDataRecorder.this.computeDataStatistics();
                    EventChannel eventChannel = ScalarDataRecorder.this.updateListenerChannel;
                    synchronized (eventChannel) {
                        ScalarDataRecorder.this.updateListenerProxy.update(new UpdateEvent(ScalarDataRecorder.this));
                    }
                }
            });
        }

        void start() {
            this.timer.start();
        }

        void stop() {
            this.timer.stop();
        }
    }

    public class UpdateEvent
    extends EventObject {
        public UpdateEvent(Object object) {
            super(object);
        }
    }

    public static interface UpdateListener
    extends EventListener {
        public void update(UpdateEvent var1);
    }
}

