/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.controller;

import edu.colorado.phet.common.controls.SpectrumSliderWithSquareCursor;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.photoelectric.PhotoelectricResources;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpectrumSliderWithReadout
extends SpectrumSliderWithSquareCursor {
    private Beam beam;
    private WavelengthReadout readout;

    public SpectrumSliderWithReadout(Component component, SpectrumSliderWithSquareCursor spectrumSliderWithSquareCursor, Beam beam, double d, double d2, Point point) {
        super(component, d, d2);
        this.beam = beam;
        beam.addWavelengthChangeListener(new WavelengthChangeListener());
        this.readout = new WavelengthReadout(component, point, d, d2);
        ((ApparatusPanel)component).addGraphic(this.readout, 1.0E14);
        this.setKnob(spectrumSliderWithSquareCursor.getKnob());
        this.addChangeListener(this.readout);
    }

    public void setValue(int n) {
        super.setValue(n);
    }

    public class WavelengthChangeListener
    implements PhotonSource.WavelengthChangeListener {
        public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
            if ((int)wavelengthChangeEvent.getWavelength() != SpectrumSliderWithReadout.this.getValue()) {
                SpectrumSliderWithReadout.this.setValue((int)wavelengthChangeEvent.getWavelength());
            }
        }
    }

    public class WavelengthReadout
    extends GraphicLayerSet
    implements ChangeListener {
        private Font VALUE_FONT;
        private JTextField readout;
        private PhetGraphic readoutGraphic;
        private Point baseLocation;
        private double minWavelength;
        private double maxWavelength;

        public WavelengthReadout(final Component component, Point point, double d, double d2) {
            super(component);
            this.VALUE_FONT = new Font("SansSerif", 0, 12);
            this.baseLocation = point;
            this.minWavelength = d;
            this.maxWavelength = d2;
            this.readout = new JTextField(5);
            this.readout.setHorizontalAlignment(4);
            this.readout.setFont(this.VALUE_FONT);
            this.readout.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    WavelengthReadout.this.update(component);
                }
            });
            this.readout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WavelengthReadout.this.update(component);
                }
            });
            this.readoutGraphic = PhetJComponent.newInstance(component, this.readout);
            this.addGraphic(this.readoutGraphic, 1.0E9);
            this.update(SpectrumSliderWithReadout.this.beam.getWavelength());
        }

        private void update(Component component) {
            double d = 0.0;
            try {
                String string = this.readout.getText().toLowerCase();
                int n = string.indexOf("nm");
                string = n >= 0 ? this.readout.getText().substring(0, n) : string;
                d = MathUtil.clamp(this.minWavelength, Double.parseDouble(string), this.maxWavelength);
                SpectrumSliderWithReadout.this.beam.setWavelength(d);
                this.update(d);
            }
            catch (NumberFormatException numberFormatException) {
                PhetOptionPane.showErrorDialog(SwingUtilities.getRoot(component), PhotoelectricResources.getString("Wavelength.message"));
                this.setText(SpectrumSliderWithReadout.this.beam.getWavelength());
            }
        }

        private void update(double d) {
            int n = (int)((double)this.baseLocation.x + SpectrumSliderWithReadout.this.getKnob().getLocation().getX() - this.getBounds().getWidth() / 2.0 - 15.0);
            int n2 = this.baseLocation.y - this.getHeight() - 5;
            this.setLocation(n, n2);
            this.setText(d);
        }

        private void setText(double d) {
            DecimalFormat decimalFormat = new DecimalFormat("000");
            this.readout.setText(decimalFormat.format(d) + " " + PhotoelectricResources.getString("units.nm"));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == SpectrumSliderWithReadout.this) {
                this.update(SpectrumSliderWithReadout.this.getValue());
            }
        }
    }
}

