/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.math.ModelViewTransform1D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.controller.module.MultipleAtomModule;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.view.EnergyLevelGraphic;
import edu.colorado.phet.lasers.view.EnergyLifetimeSlider;
import edu.colorado.phet.lasers.view.EnergyMatchDetector;
import edu.colorado.phet.lasers.view.LevelIcon;
import edu.colorado.phet.lasers.view.MonitorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;

public class LaserEnergyLevelMonitorPanel
extends MonitorPanel
implements ClockListener,
SimpleObserver,
PhotonSource.RateChangeListener,
PhotonSource.WavelengthChangeListener {
    private long averagingPeriod = 0L;
    private long lastPaintTime;
    private int numUpdatesToAverage;
    private int atomDiam = 10;
    private double panelHeight = 230.0;
    private double panelWidth = 320.0;
    private int squiggleHeight = this.atomDiam;
    private Point2D origin = new Point2D.Double(25.0, this.panelHeight - 30.0);
    private double levelLineOriginX = this.origin.getX();
    private double levelLineLength = this.panelWidth - this.levelLineOriginX - 50.0;
    private EnergyLevelGraphic[] levelGraphics = new EnergyLevelGraphic[3];
    private EnergyLifetimeSlider[] lifetimeSliders = new EnergyLifetimeSlider[3];
    private HashMap defaultLifetimes = new HashMap();
    private int[] numAtomsInLevel = new int[3];
    private int[] atomCntAccums = new int[3];
    private int numLevels;
    private LaserModel model;
    private double pumpBeamEnergy;
    private double seedBeamEnergy;
    private ModelViewTransform1D energyYTx;
    private BufferedImage stimSquiggle;
    private BufferedImage pumpSquiggle;
    private AffineTransform stimSquiggleTx;
    private AffineTransform pumpSquiggleTx;
    private BufferedImage baseSphereImg;
    private BaseLaserModule module;
    private int headerOffsetY = 20;
    private int footerOffsetY = 10;
    private IClock clock;
    private Map colorToAtomImage = new HashMap();

    public LaserEnergyLevelMonitorPanel(BaseLaserModule baseLaserModule, IClock iClock) {
        this.module = baseLaserModule;
        this.clock = iClock;
        this.model = baseLaserModule.getLaserModel();
        this.model.addObserver(this);
        iClock.addClockListener(this);
        this.model.getPumpingBeam().addWavelengthChangeListener(this);
        this.model.getPumpingBeam().addRateChangeListener(this);
        this.model.getSeedBeam().addWavelengthChangeListener(this);
        this.model.getSeedBeam().addRateChangeListener(this);
        this.model.addLaserListener(new LaserModel.ChangeListenerAdapter(){

            public void atomicStatesChanged(LaserModel.ChangeEvent changeEvent) {
                LaserEnergyLevelMonitorPanel.this.relayout();
            }
        });
        this.createEnergyLevelReps();
        this.setBackground(Color.white);
        JLabel jLabel = new JLabel("foo");
        Font font = jLabel.getFont();
        String string = null;
        string = baseLaserModule instanceof MultipleAtomModule ? LasersResources.getString("EnergyMonitorPanel.header.plural") : LasersResources.getString("EnergyMonitorPanel.header.singular");
        PhetTextGraphic phetTextGraphic = new PhetTextGraphic(this, font, string, Color.black);
        phetTextGraphic.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        phetTextGraphic.setLocation(25, 5);
        this.addGraphic(phetTextGraphic);
        this.addComponentListener(new PanelResizer());
    }

    private void createEnergyLevelReps() {
        Object object;
        int n;
        for (n = 0; n < this.levelGraphics.length; ++n) {
            object = this.levelGraphics[n];
            this.removeGraphic((PhetGraphic)object);
        }
        for (n = 0; n < this.lifetimeSliders.length; ++n) {
            object = this.lifetimeSliders[n];
            if (object == null) continue;
            this.remove((Component)object);
        }
        this.levelGraphics = new EnergyLevelGraphic[3];
        this.lifetimeSliders = new EnergyLifetimeSlider[3];
        AtomicState[] atomicStateArray = this.model.getStates();
        for (int i = 0; i < atomicStateArray.length; ++i) {
            AtomicState atomicState = atomicStateArray[i];
            double d = 5.0;
            double d2 = this.levelLineOriginX + d;
            boolean bl = i != 0;
            EnergyLevelGraphic energyLevelGraphic = new EnergyLevelGraphic(this, atomicState, atomicStateArray[0].getEnergyLevel(), d2, this.levelLineLength - this.levelLineOriginX, bl, this.levelLineOriginX + this.levelLineLength - 25.0, true);
            this.addGraphic(energyLevelGraphic, 1000.0);
            this.levelGraphics[i] = energyLevelGraphic;
            if (i > 0) {
                int n2 = (int)this.clock.getSimulationTimeChange() * 2;
                int n3 = i == 1 ? 400 : 100;
                atomicState.setMeanLifetime(n3);
                this.lifetimeSliders[i] = new EnergyLifetimeSlider(atomicState, energyLevelGraphic, n3, n2, this);
                this.add(this.lifetimeSliders[i]);
                this.defaultLifetimes.put(this.lifetimeSliders[i], new Integer(this.lifetimeSliders[i].getValue()));
                new EnergyMatchDetector(this.model, atomicState, this.model.getSeedBeam(), energyLevelGraphic);
                new EnergyMatchDetector(this.model, atomicState, this.model.getPumpingBeam(), energyLevelGraphic);
            }
            Atom atom = new Atom(this.model, this.levelGraphics.length, true);
            AtomicState[] atomicStateArray2 = new AtomicState[atomicStateArray.length];
            for (int j = 0; j < atomicStateArray.length; ++j) {
                atomicStateArray2[j] = new AtomicState(atomicStateArray[j]);
                atomicStateArray2[j].setMeanLifetime(Double.MAX_VALUE);
            }
            atom.setStates(atomicStateArray2);
            atom.setCurrState(atomicStateArray2[i]);
            this.levelGraphics[i].setLevelIcon(new LevelIcon(this, atom));
        }
        this.relayout();
    }

    public void relayout() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.getBounds().getMinX(), this.getBounds().getMinY() + 10.0, this.getBounds().getWidth(), this.getBounds().getHeight() - 30.0);
        double d = this.model.getGroundState().getEnergyLevel();
        this.energyYTx = new ModelViewTransform1D(d + PhysicsUtil.wavelengthToEnergy(380.0), d, (int)double_.getBounds().getMinY() + this.headerOffsetY, (int)double_.getBounds().getMaxY() - this.footerOffsetY);
        for (int i = 0; i < this.levelGraphics.length; ++i) {
            if (this.levelGraphics[i] == null) continue;
            this.levelGraphics[i].setTransform(this.energyYTx);
        }
        this.updateSquiggles();
    }

    public void setNumLevels(int n) {
        this.numLevels = n;
        this.createEnergyLevelReps();
        this.setPreferredSize(new Dimension((int)this.panelWidth, (int)this.panelHeight));
        this.revalidate();
        this.repaint();
    }

    public void reset() {
        Set set = this.defaultLifetimes.keySet();
        for (EnergyLifetimeSlider energyLifetimeSlider : set) {
            energyLifetimeSlider.setValue((Integer)this.defaultLifetimes.get(energyLifetimeSlider));
        }
    }

    public void update() {
        this.atomCntAccums[0] = this.atomCntAccums[0] + this.model.getNumGroundStateAtoms();
        this.atomCntAccums[1] = this.atomCntAccums[1] + this.model.getNumMiddleStateAtoms();
        this.atomCntAccums[2] = this.atomCntAccums[2] + this.model.getNumHighStateAtoms();
        for (int i = 1; i < this.numLevels; ++i) {
            if (this.lifetimeSliders[i] == null) continue;
            this.lifetimeSliders[i].updateBounds();
        }
        ++this.numUpdatesToAverage;
        long l = System.currentTimeMillis();
        if (l - this.lastPaintTime >= this.averagingPeriod) {
            this.numAtomsInLevel[0] = (int)(0.5 + (double)this.atomCntAccums[0] / (double)this.numUpdatesToAverage);
            this.numAtomsInLevel[1] = (int)(0.5 + (double)this.atomCntAccums[1] / (double)this.numUpdatesToAverage);
            this.numAtomsInLevel[2] = (int)(0.5 + (double)this.atomCntAccums[2] / (double)this.numUpdatesToAverage);
            this.atomCntAccums[0] = 0;
            this.atomCntAccums[1] = 0;
            this.atomCntAccums[2] = 0;
            this.numUpdatesToAverage = 0;
            this.lastPaintTime = l;
            this.invalidate();
            this.repaint();
        }
    }

    private void updateSquiggles() {
        double d = this.model.getGroundState().getEnergyLevel();
        double d2 = this.energyYTx.modelToView(d);
        double d3 = this.energyYTx.modelToView(d + this.seedBeamEnergy);
        double d4 = this.energyYTx.modelToView(d + this.pumpBeamEnergy);
        if (d2 > d3) {
            double d5 = this.squiggleHeight;
            this.stimSquiggle = this.computeSquiggleImage(this.model.getSeedBeam(), 0.0, (int)(d2 - d3), this.squiggleHeight);
            this.stimSquiggleTx = AffineTransform.getTranslateInstance(this.levelGraphics[1].getPosition().getX() + d5, this.energyYTx.modelToView(this.module.getLaserModel().getGroundState().getEnergyLevel()));
            this.stimSquiggleTx.rotate(-1.5707963267948966);
        }
        if (d2 > d4) {
            this.pumpSquiggle = this.computeSquiggleImage(this.model.getPumpingBeam(), 0.0, (int)(d2 - d4), this.squiggleHeight);
            int n = this.numLevels > 2 ? 2 : 1;
            this.pumpSquiggleTx = AffineTransform.getTranslateInstance(this.levelGraphics[n].getPosition().getX(), this.energyYTx.modelToView(this.module.getLaserModel().getGroundState().getEnergyLevel()));
            this.pumpSquiggleTx.rotate(-1.5707963267948966);
        }
        this.invalidate();
        this.repaint();
    }

    private BufferedImage computeSquiggleImage(Beam beam, double d, int n, int n2) {
        double d2 = beam.getWavelength();
        int n3 = n2;
        int n4 = n - 1;
        BufferedImage bufferedImage = new BufferedImage(n4 + 2 * n3, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n5 = n2 / 2;
        int n6 = 0;
        Color color = VisibleColor.wavelengthToColor(d2);
        double d3 = 15.0 * d2 / 680.0;
        for (int i = 0; i < n4 - n3 * 2; ++i) {
            int n7 = (int)(Math.sin(d + (double)i * Math.PI * 2.0 / d3) * (double)n2 / 2.0 + (double)(n2 / 2));
            for (int j = 0; j < n2; ++j) {
                if (j != n7) continue;
                graphics2D.setColor(color);
                graphics2D.drawLine(n6 + n3, n5, i + n3, n7);
                n6 = i;
                n5 = n7;
            }
        }
        Arrow arrow = new Arrow(new Point2D.Double(n3, n2 / 2), new Point2D.Double(0.0, n2 / 2), n3, (double)n2 * 1.2, 2.0);
        Arrow arrow2 = new Arrow(new Point2D.Double(n4 - n3, n2 / 2), new Point2D.Double(n4, n2 / 2), n3, (double)n2 * 1.2, 2.0);
        graphics2D.fill(arrow.getShape());
        graphics2D.fill(arrow2.getShape());
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setAveragingPeriod(long l) {
        this.averagingPeriod = l;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        for (int i = 0; i < this.numLevels; ++i) {
            EnergyLevelGraphic energyLevelGraphic = this.levelGraphics[i];
            this.drawAtomsInLevel(graphics2D, Color.darkGray, energyLevelGraphic, this.numAtomsInLevel[i]);
        }
        if (this.stimSquiggle != null && this.model.getSeedBeam().isEnabled()) {
            double d = this.model.getSeedBeam().getPhotonsPerSecond() / this.model.getSeedBeam().getMaxPhotonsPerSecond();
            GraphicsUtil.setAlpha(graphics2D, Math.pow(d, 0.5));
            graphics2D.drawRenderedImage(this.stimSquiggle, this.stimSquiggleTx);
        }
        if (this.pumpSquiggle != null && this.model.getPumpingBeam().isEnabled()) {
            double d = this.model.getPumpingBeam().getPhotonsPerSecond() / this.model.getPumpingBeam().getMaxPhotonsPerSecond();
            GraphicsUtil.setAlpha(graphics2D, Math.sqrt(d));
            graphics2D.drawRenderedImage(this.pumpSquiggle, this.pumpSquiggleTx);
        }
        graphicsState.restoreGraphics();
    }

    private void drawAtomsInLevel(Graphics2D graphics2D, Color color, EnergyLevelGraphic energyLevelGraphic, int n) {
        BufferedImage bufferedImage = this.getAtomImage(color);
        double d = (double)this.atomDiam / (double)bufferedImage.getWidth();
        AffineTransform affineTransform = new AffineTransform();
        double d2 = this.squiggleHeight * 2;
        affineTransform.translate(energyLevelGraphic.getLinePosition().getX() + d2 - (double)(this.atomDiam / 2), energyLevelGraphic.getLinePosition().getY() - (double)this.atomDiam);
        affineTransform.scale(d, d);
        for (int i = 0; i < n; ++i) {
            affineTransform.translate((double)this.atomDiam * 0.7 / d, 0.0);
            graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        }
    }

    private BufferedImage getAtomImage(Color color) {
        BufferedImage bufferedImage;
        if (this.baseSphereImg == null) {
            try {
                this.baseSphereImg = ImageLoader.loadBufferedImage("lasers/images/particle-red-lrg.gif");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if ((bufferedImage = (BufferedImage)this.colorToAtomImage.get(color)) == null) {
            bufferedImage = new BufferedImage(this.baseSphereImg.getWidth(), this.baseSphereImg.getHeight(), 3);
            MakeDuotoneImageOp makeDuotoneImageOp = new MakeDuotoneImageOp(color);
            makeDuotoneImageOp.filter(this.baseSphereImg, bufferedImage);
            this.colorToAtomImage.put(color, bufferedImage);
        }
        return bufferedImage;
    }

    public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
        double d;
        Beam beam = (Beam)wavelengthChangeEvent.getSource();
        if (beam == this.model.getPumpingBeam()) {
            d = beam.getWavelength();
            this.pumpBeamEnergy = PhysicsUtil.wavelengthToEnergy(d);
        }
        if (beam == this.model.getSeedBeam()) {
            d = beam.getWavelength();
            this.seedBeamEnergy = PhysicsUtil.wavelengthToEnergy(d);
        }
        this.updateSquiggles();
    }

    public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
        this.updateSquiggles();
    }

    public void clockTicked(ClockEvent clockEvent) {
    }

    public void clockStarted(ClockEvent clockEvent) {
    }

    public void clockPaused(ClockEvent clockEvent) {
        this.numGroundLevel = this.model.getNumGroundStateAtoms();
        this.numMiddleLevel = this.model.getNumMiddleStateAtoms();
        this.numHighLevel = this.model.getNumHighStateAtoms();
        this.invalidate();
        this.repaint();
    }

    public void simulationTimeChanged(ClockEvent clockEvent) {
    }

    public void simulationTimeReset(ClockEvent clockEvent) {
    }

    private class PanelResizer
    extends ComponentAdapter {
        private PanelResizer() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            LaserEnergyLevelMonitorPanel.this.relayout();
        }
    }
}

